/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.datafactory;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.models.CreateRunResponse;
import com.azure.resourcemanager.datafactory.models.PipelineResource;
import com.azure.resourcemanager.datafactory.models.PipelineRun;
import com.azure.resourcemanager.datafactory.models.PipelineRuns;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.datafactory.DatafactoryParameters;
import org.apache.dolphinscheduler.plugin.task.datafactory.DatafactoryStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatafactoryHook {
    public static DatafactoryStatus[] taskFinishFlags = new DatafactoryStatus[]{DatafactoryStatus.Failed, DatafactoryStatus.Succeeded, DatafactoryStatus.Cancelled};
    protected final Logger log = LoggerFactory.getLogger(DatafactoryHook.class);
    private final int QUERY_INTERVAL = PropertyUtils.getInt((String)"resource.query.interval", (int)10000);
    private DataFactoryManager client;
    private static AzureProfile profile;
    private static ClientSecretCredential credential;
    private String runId;

    public DatafactoryHook() {
        this.log.info("initDatafactoryClient ......");
        this.client = DatafactoryHook.createClient();
    }

    protected static DataFactoryManager createClient() {
        String AZURE_ACCESS_SUB_ID = PropertyUtils.getString((String)"resource.azure.subId");
        String AZURE_SECRET_TENANT_ID = PropertyUtils.getString((String)"resource.azure.tenant.id");
        String AZURE_CLIENT_ID = PropertyUtils.getString((String)"resource.azure.client.id");
        String AZURE_CLIENT_SECRET = PropertyUtils.getString((String)"resource.azure.client.secret");
        profile = new AzureProfile(AZURE_SECRET_TENANT_ID, AZURE_ACCESS_SUB_ID, AzureEnvironment.AZURE);
        credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(AZURE_CLIENT_ID)).clientSecret(AZURE_CLIENT_SECRET).tenantId(AZURE_SECRET_TENANT_ID)).authorityHost(profile.getEnvironment().getActiveDirectoryEndpoint())).build();
        return DataFactoryManager.authenticate((TokenCredential)credential, (AzureProfile)profile);
    }

    public Boolean startDatafactoryTask(DatafactoryParameters parameters) {
        this.log.info("initDatafactoryTask ......");
        PipelineResource pipelineResource = this.getPipelineResource(parameters);
        if (pipelineResource == null) {
            return false;
        }
        this.log.info("startDatafactoryTask ......");
        CreateRunResponse run = pipelineResource.createRun();
        if (StringUtils.isEmpty((CharSequence)run.runId())) {
            return false;
        }
        this.runId = run.runId();
        parameters.setRunId(this.runId);
        return true;
    }

    public Boolean cancelDatafactoryTask(DatafactoryParameters parameters) {
        this.log.info("cancelTask ......");
        PipelineRuns pipelineRuns = this.client.pipelineRuns();
        try {
            pipelineRuns.cancel(parameters.getResourceGroupName(), parameters.getFactoryName(), this.runId);
        }
        catch (RuntimeException e) {
            this.log.error("failed to cancel datafactory task: " + e.getMessage());
            return false;
        }
        return true;
    }

    public DatafactoryStatus queryDatafactoryTaskStatus(DatafactoryParameters parameters) {
        this.log.info("queryDatafactoryTaskStatus ......");
        PipelineRuns pipelineRuns = this.client.pipelineRuns();
        PipelineRun pipelineRun = pipelineRuns.get(parameters.getResourceGroupName(), parameters.getFactoryName(), this.runId);
        if (pipelineRun != null) {
            this.log.info("queryDatafactoryTaskStatus ......{}", (Object)pipelineRun.status());
            return DatafactoryStatus.valueOf(pipelineRun.status());
        }
        return null;
    }

    private PipelineResource getPipelineResource(DatafactoryParameters parameters) {
        return this.client.pipelines().get(parameters.getResourceGroupName(), parameters.getFactoryName(), parameters.getPipelineName());
    }

    public Boolean queryStatus(DatafactoryParameters parameters) {
        List<DatafactoryStatus> stopStatusSet = Arrays.asList(taskFinishFlags);
        int maxRetry = 5;
        while (maxRetry > 0) {
            DatafactoryStatus status = this.queryDatafactoryTaskStatus(parameters);
            if (status == null) {
                --maxRetry;
                continue;
            }
            if (stopStatusSet.contains((Object)status)) {
                if (status.equals((Object)DatafactoryStatus.Succeeded)) {
                    return true;
                }
                return false;
            }
            this.log.debug("wait {}ms to recheck finish status....", (Object)this.QUERY_INTERVAL);
            Thread.sleep(this.QUERY_INTERVAL);
        }
        return false;
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public int getQUERY_INTERVAL() {
        return this.QUERY_INTERVAL;
    }

    @Generated
    public DataFactoryManager getClient() {
        return this.client;
    }

    @Generated
    public String getRunId() {
        return this.runId;
    }

    @Generated
    public void setClient(DataFactoryManager client) {
        this.client = client;
    }

    @Generated
    public void setRunId(String runId) {
        this.runId = runId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatafactoryHook)) {
            return false;
        }
        DatafactoryHook other = (DatafactoryHook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQUERY_INTERVAL() != other.getQUERY_INTERVAL()) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        DataFactoryManager this$client = this.getClient();
        DataFactoryManager other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$runId = this.getRunId();
        String other$runId = other.getRunId();
        return !(this$runId == null ? other$runId != null : !this$runId.equals(other$runId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DatafactoryHook;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQUERY_INTERVAL();
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        DataFactoryManager $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $runId = this.getRunId();
        result = result * 59 + ($runId == null ? 43 : $runId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DatafactoryHook(log=" + this.getLog() + ", QUERY_INTERVAL=" + this.getQUERY_INTERVAL() + ", client=" + this.getClient() + ", runId=" + this.getRunId() + ")";
    }
}

