/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import java.io.Serializable;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskConstants;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parser.PlaceholderUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.TimePlaceholderUtils;

public class ParameterUtils {
    private static final Pattern DATE_PARSE_PATTERN = Pattern.compile("\\$\\[([^\\$\\]]+)]");
    private static final char PARAM_REPLACE_CHAR = '?';

    private ParameterUtils() {
        throw new UnsupportedOperationException("Construct ParameterUtils");
    }

    public static String convertParameterPlaceholders(String parameterString, Map<String, String> parameterMap) {
        java.util.Date cronTime;
        if (StringUtils.isEmpty((CharSequence)parameterString)) {
            return parameterString;
        }
        if (parameterMap != null && !parameterMap.isEmpty()) {
            parameterString = PlaceholderUtils.replacePlaceholders(parameterString, parameterMap, true);
        }
        if (parameterMap != null && null != parameterMap.get("system.datetime")) {
            String cronTimeStr = parameterMap.get("system.datetime");
            cronTime = DateUtils.parse((String)cronTimeStr, (String)"yyyyMMddHHmmss");
        } else {
            cronTime = new java.util.Date();
        }
        if (cronTime != null) {
            return ParameterUtils.dateTemplateParse(parameterString, cronTime);
        }
        return parameterString;
    }

    public static String convertParameterPlaceholders2(String parameterString, Map<String, String> parameterMap) {
        if (StringUtils.isEmpty((CharSequence)parameterString)) {
            return parameterString;
        }
        String cronTimeStr = parameterMap.get("schedule.time");
        java.util.Date cronTime = null;
        cronTime = StringUtils.isNotEmpty((CharSequence)cronTimeStr) ? DateUtils.parse((String)cronTimeStr, (String)"yyyyMMddHHmmss") : new java.util.Date();
        if (!parameterMap.isEmpty()) {
            parameterString = PlaceholderUtils.replacePlaceholders(parameterString, parameterMap, true);
        }
        if (cronTime != null) {
            return ParameterUtils.dateTemplateParse(parameterString, cronTime);
        }
        return parameterString;
    }

    public static void setInParameter(int index, PreparedStatement stmt, DataType dataType, String value) throws Exception {
        if (dataType.equals((Object)DataType.VARCHAR)) {
            stmt.setString(index, value);
        } else if (dataType.equals((Object)DataType.INTEGER)) {
            stmt.setInt(index, Integer.parseInt(value));
        } else if (dataType.equals((Object)DataType.LONG)) {
            stmt.setLong(index, Long.parseLong(value));
        } else if (dataType.equals((Object)DataType.FLOAT)) {
            stmt.setFloat(index, Float.parseFloat(value));
        } else if (dataType.equals((Object)DataType.DOUBLE)) {
            stmt.setDouble(index, Double.parseDouble(value));
        } else if (dataType.equals((Object)DataType.DATE)) {
            stmt.setDate(index, Date.valueOf(value));
        } else if (dataType.equals((Object)DataType.TIME)) {
            stmt.setTime(index, Time.valueOf(value));
        } else if (dataType.equals((Object)DataType.TIMESTAMP)) {
            stmt.setTimestamp(index, Timestamp.valueOf(value));
        } else if (dataType.equals((Object)DataType.BOOLEAN)) {
            stmt.setBoolean(index, Boolean.parseBoolean(value));
        }
    }

    public static Serializable getParameterValue(Property property) {
        if (property == null) {
            return null;
        }
        String value = property.getValue();
        switch (property.getType()) {
            case LONG: {
                return Long.valueOf(value);
            }
            case FLOAT: {
                return Float.valueOf(value);
            }
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
        }
        return value;
    }

    public static boolean isNumber(Property property) {
        return property != null && (DataType.INTEGER.equals((Object)property.getType()) || DataType.LONG.equals((Object)property.getType()) || DataType.FLOAT.equals((Object)property.getType()) || DataType.DOUBLE.equals((Object)property.getType()));
    }

    public static boolean isBoolean(Property property) {
        return property != null && DataType.BOOLEAN.equals((Object)property.getType());
    }

    public static String expandListParameter(Map<Integer, Property> params, String sql) {
        HashMap<Integer, Property> expandMap = new HashMap<Integer, Property>();
        if (params == null || params.isEmpty()) {
            return sql;
        }
        StringBuilder ret = new StringBuilder(sql);
        Matcher m = TaskConstants.SQL_PARAMS_PATTERN.matcher(sql);
        int index = 1;
        int paramsIndex = 1;
        while (m.find()) {
            Property property;
            if ((property = params.get(paramsIndex++)) == null) continue;
            String value = property.getValue();
            StringBuilder tempReplace = new StringBuilder();
            if (DataType.LIST.equals((Object)property.getType())) {
                List valueList = JSONUtils.toList((String)value, Object.class);
                if (valueList.isEmpty() && StringUtils.isNotBlank((CharSequence)value)) {
                    valueList.add(value);
                }
                for (int j = 0; j < valueList.size(); ++j) {
                    tempReplace.append('?');
                    if (j == valueList.size() - 1) continue;
                    tempReplace.append(",");
                }
                for (Object v : valueList) {
                    Property newProperty = new Property();
                    if (v instanceof Integer) {
                        newProperty.setType(DataType.INTEGER);
                    } else if (v instanceof Long) {
                        newProperty.setType(DataType.LONG);
                    } else if (v instanceof Float) {
                        newProperty.setType(DataType.FLOAT);
                    } else if (v instanceof Double) {
                        newProperty.setType(DataType.DOUBLE);
                    } else {
                        newProperty.setType(DataType.VARCHAR);
                    }
                    newProperty.setValue(v.toString());
                    newProperty.setProp(property.getProp());
                    newProperty.setDirect(property.getDirect());
                    expandMap.put(index++, newProperty);
                }
            } else {
                tempReplace.append('?');
                expandMap.put(index++, property);
            }
            ret.replace(m.start(), m.end(), tempReplace.toString());
            m.reset(ret.toString());
        }
        params.clear();
        params.putAll(expandMap);
        return ret.toString();
    }

    public static String replaceScheduleTime(String text, java.util.Date scheduleTime) {
        HashMap<String, Property> paramsMap = new HashMap<String, Property>();
        if (null == scheduleTime) {
            scheduleTime = new java.util.Date();
        }
        String dateTime = DateUtils.format((java.util.Date)scheduleTime, (String)"yyyyMMddHHmmss");
        Property p = new Property();
        p.setValue(dateTime);
        p.setProp("schedule.time");
        paramsMap.put("schedule.time", p);
        text = ParameterUtils.convertParameterPlaceholders2(text, ParameterUtils.convert(paramsMap));
        return text;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        if (paramsMap == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }

    private static String dateTemplateParse(String templateStr, java.util.Date date) {
        if (StringUtils.isEmpty((CharSequence)templateStr)) {
            return templateStr;
        }
        StringBuffer newValue = new StringBuffer(templateStr.length());
        Matcher matcher = DATE_PARSE_PATTERN.matcher(templateStr);
        while (matcher.find()) {
            String value;
            String key = matcher.group(1);
            if (StringUtils.equals((CharSequence)key, (CharSequence)(value = TimePlaceholderUtils.formatTimeExpression(key, date, true)))) continue;
            matcher.appendReplacement(newValue, value);
        }
        matcher.appendTail(newValue);
        return newValue.toString();
    }

    public static String handleEscapes(String inputString) {
        if (!StringUtils.isEmpty((CharSequence)inputString)) {
            return inputString.replace("%", "////%").replaceAll("[\n|\r\t]", "_");
        }
        return inputString;
    }

    public static Map<String, Property> getUserDefParamsMap(Map<String, String> definedParams) {
        HashMap<String, Property> userDefParamsMaps = new HashMap<String, Property>();
        if (definedParams != null) {
            for (Map.Entry<String, String> en : definedParams.entrySet()) {
                Property property = new Property(en.getKey(), Direct.IN, DataType.VARCHAR, en.getValue());
                userDefParamsMaps.put(property.getProp(), property);
            }
        }
        return userDefParamsMaps;
    }
}

