/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum RuleType {
    SINGLE_TABLE(0, "single_table"),
    SINGLE_TABLE_CUSTOM_SQL(1, "single_table_custom_sql"),
    MULTI_TABLE_ACCURACY(2, "multi_table_accuracy"),
    MULTI_TABLE_COMPARISON(3, "multi_table_comparison");

    private final int code;
    private final String description;
    private static final Map<Integer, RuleType> VALUES_MAP;

    private RuleType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static RuleType of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, RuleType>();
        for (RuleType type : RuleType.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

