/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.obs;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.plugin.storage.api.AbstractStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.obs.ObsStorageProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsStorageOperator
extends AbstractStorageOperator
implements Closeable,
StorageOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObsStorageOperator.class);
    private final String bucketName;
    private final ObsClient obsClient;

    public ObsStorageOperator(ObsStorageProperties obsStorageProperties) {
        super(obsStorageProperties.getResourceUploadPath());
        this.bucketName = obsStorageProperties.getBucketName();
        this.obsClient = new ObsClient(obsStorageProperties.getAccessKeyId(), obsStorageProperties.getAccessKeySecret(), obsStorageProperties.getEndPoint());
        this.ensureBucketSuccessfullyCreated(this.bucketName);
    }

    @Override
    public void close() throws IOException {
        this.obsClient.close();
    }

    public String getStorageBaseDirectory() {
        if (this.resourceBaseAbsolutePath.startsWith("/")) {
            log.warn("{} -> {} should not start with / in obs", (Object)"resource.storage.upload.base.path", (Object)this.resourceBaseAbsolutePath);
            return this.resourceBaseAbsolutePath.substring(1);
        }
        return this.resourceBaseAbsolutePath;
    }

    public void createStorageDir(String directoryAbsolutePath) {
        directoryAbsolutePath = this.transformAbsolutePathToObsKey(directoryAbsolutePath);
        if (this.obsClient.doesObjectExist(this.bucketName, directoryAbsolutePath)) {
            throw new FileAlreadyExistsException("directory: " + directoryAbsolutePath + " already exists");
        }
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(Long.valueOf(0L));
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, directoryAbsolutePath, (InputStream)emptyContent);
        this.obsClient.putObject(putObjectRequest);
    }

    public void download(String srcFilePath, String dstFilePath, boolean overwrite) {
        srcFilePath = this.transformAbsolutePathToObsKey(srcFilePath);
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            FileUtils.createDirectoryWithPermission((Path)dstFile.getParentFile().toPath(), (Set)FileUtils.PERMISSION_755);
        }
        ObsObject obsObject = this.obsClient.getObject(this.bucketName, srcFilePath);
        try (InputStream obsInputStream = obsObject.getObjectContent();
             FileOutputStream fos = new FileOutputStream(dstFilePath);){
            int readLen;
            byte[] readBuf = new byte[1024];
            while ((readLen = obsInputStream.read(readBuf)) > 0) {
                fos.write(readBuf, 0, readLen);
            }
        }
    }

    public boolean exists(String fileName) {
        fileName = this.transformAbsolutePathToObsKey(fileName);
        return this.obsClient.doesObjectExist(this.bucketName, fileName);
    }

    public void delete(String filePath, boolean recursive) {
        filePath = this.transformAbsolutePathToObsKey(filePath);
        this.obsClient.deleteObject(this.bucketName, filePath);
    }

    public void copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) {
        srcPath = this.transformAbsolutePathToObsKey(srcPath);
        dstPath = this.transformAbsolutePathToObsKey(dstPath);
        this.obsClient.copyObject(this.bucketName, srcPath, this.bucketName, dstPath);
        if (deleteSource) {
            this.obsClient.deleteObject(this.bucketName, srcPath);
        }
    }

    public void upload(String srcFile, String dstPath, boolean deleteSource, boolean overwrite) {
        dstPath = this.transformAbsolutePathToObsKey(dstPath);
        if (this.obsClient.doesObjectExist(this.bucketName, dstPath)) {
            if (!overwrite) {
                throw new ObsException("file: " + dstPath + " already exists");
            }
            this.obsClient.deleteObject(this.bucketName, dstPath);
        }
        this.obsClient.putObject(this.bucketName, dstPath, new File(srcFile));
        if (deleteSource) {
            Files.delete(Paths.get(srcFile, new String[0]));
        }
    }

    /*
     * Exception decompiling
     */
    public List<String> fetchFileContent(String filePath, int skipLineNums, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<StorageEntity> listStorageEntity(String resourceAbsolutePath) {
        resourceAbsolutePath = this.transformObsKeyToAbsolutePath(resourceAbsolutePath);
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucketName);
        request.setPrefix(resourceAbsolutePath);
        request.setDelimiter("/");
        ObjectListing result = this.obsClient.listObjects(request);
        return result.getObjects().stream().map(this::transformObsObjectToStorageEntity).collect(Collectors.toList());
    }

    public List<StorageEntity> listFileStorageEntityRecursively(String resourceAbsolutePath) {
        resourceAbsolutePath = this.transformObsKeyToAbsolutePath(resourceAbsolutePath);
        HashSet<String> visited = new HashSet<String>();
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<String> foldersToFetch = new LinkedList<String>();
        foldersToFetch.addLast(resourceAbsolutePath);
        while (!foldersToFetch.isEmpty()) {
            String pathToExplore = (String)foldersToFetch.pop();
            visited.add(pathToExplore);
            List<StorageEntity> tempList = this.listStorageEntity(pathToExplore);
            for (StorageEntity temp : tempList) {
                if (!temp.isDirectory() || visited.contains(temp.getFullName())) continue;
                foldersToFetch.add(temp.getFullName());
            }
            storageEntityList.addAll(tempList);
        }
        return storageEntityList;
    }

    public StorageEntity getStorageEntity(String resourceAbsolutePath) {
        resourceAbsolutePath = this.transformObsKeyToAbsolutePath(resourceAbsolutePath);
        ObsObject object = this.obsClient.getObject(this.bucketName, resourceAbsolutePath);
        return this.transformObsObjectToStorageEntity(object);
    }

    public void ensureBucketSuccessfullyCreated(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("resource.alibaba.cloud.obs.bucket.name is empty");
        }
        boolean existsBucket = this.obsClient.headBucket(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found", (Object)bucketName);
    }

    protected StorageEntity transformObsObjectToStorageEntity(ObsObject object) {
        ObjectMetadata metadata = object.getMetadata();
        String fileAbsolutePath = this.transformObsKeyToAbsolutePath(object.getObjectKey());
        ResourceMetadata resourceMetaData = this.getResourceMetaData(fileAbsolutePath);
        String fileExtension = com.google.common.io.Files.getFileExtension((String)resourceMetaData.getResourceAbsolutePath());
        return StorageEntity.builder().fileName(new File(fileAbsolutePath).getName()).fullName(fileAbsolutePath).pfullName(resourceMetaData.getResourceParentAbsolutePath()).type(resourceMetaData.getResourceType()).isDirectory(StringUtils.isEmpty((CharSequence)fileExtension)).size(metadata.getContentLength().longValue()).relativePath(resourceMetaData.getResourceRelativePath()).createTime(metadata.getLastModified()).updateTime(metadata.getLastModified()).build();
    }

    private String transformAbsolutePathToObsKey(String absolutePath) {
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        if (resourceMetaData.isDirectory()) {
            return FileUtils.concatFilePath((String[])new String[]{absolutePath, "/"});
        }
        return absolutePath;
    }

    private String transformObsKeyToAbsolutePath(String s3Key) {
        if (s3Key.endsWith("/")) {
            return s3Key.substring(0, s3Key.length() - 1);
        }
        return s3Key;
    }
}

