/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.registry;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dolphinscheduler.common.utils.HeartBeat;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(HeartBeatTask.class);
    private final Set<String> heartBeatPaths;
    private final RegistryClient registryClient;
    private int workerWaitingTaskCount;
    private final String serverType;
    private final HeartBeat heartBeat;
    private final int heartBeatErrorThreshold;
    private final AtomicInteger heartBeatErrorTimes = new AtomicInteger();

    public HeartBeatTask(long startupTime, double maxCpuloadAvg, double reservedMemory, Set<String> heartBeatPaths, String serverType, RegistryClient registryClient, int heartBeatErrorThreshold) {
        this.heartBeatPaths = heartBeatPaths;
        this.registryClient = registryClient;
        this.serverType = serverType;
        this.heartBeat = new HeartBeat(startupTime, maxCpuloadAvg, reservedMemory);
        this.heartBeatErrorThreshold = heartBeatErrorThreshold;
    }

    public HeartBeatTask(long startupTime, double maxCpuloadAvg, double reservedMemory, int hostWeight, Set<String> heartBeatPaths, String serverType, RegistryClient registryClient, int workerThreadCount, int workerWaitingTaskCount, int heartBeatErrorThreshold) {
        this.heartBeatPaths = heartBeatPaths;
        this.registryClient = registryClient;
        this.workerWaitingTaskCount = workerWaitingTaskCount;
        this.serverType = serverType;
        this.heartBeat = new HeartBeat(startupTime, maxCpuloadAvg, reservedMemory, hostWeight, workerThreadCount);
        this.heartBeatErrorThreshold = heartBeatErrorThreshold;
    }

    public String getHeartBeatInfo() {
        return this.heartBeat.encodeHeartBeat();
    }

    @Override
    public void run() {
        block4: {
            try {
                for (String heartBeatPath : this.heartBeatPaths) {
                    if (!this.registryClient.checkIsDeadServer(heartBeatPath, this.serverType)) continue;
                    this.registryClient.getStoppable().stop("i was judged to death, release resources and stop myself");
                    return;
                }
                this.heartBeat.setWorkerWaitingTaskCount(this.workerWaitingTaskCount);
                for (String heartBeatPath : this.heartBeatPaths) {
                    this.registryClient.persistEphemeral(heartBeatPath, this.heartBeat.encodeHeartBeat());
                }
                this.heartBeatErrorTimes.set(0);
            }
            catch (Throwable ex) {
                this.logger.error("HeartBeat task execute failed", ex);
                if (this.heartBeatErrorTimes.incrementAndGet() < this.heartBeatErrorThreshold) break block4;
                this.registryClient.getStoppable().stop("HeartBeat task connect to zk failed too much times: " + this.heartBeatErrorTimes);
            }
        }
    }
}

