/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.StateEventChangeCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.processor.queue.StateEventResponseService;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateEventProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(StateEventProcessor.class);
    private StateEventResponseService stateEventResponseService = (StateEventResponseService)SpringApplicationContext.getBean(StateEventResponseService.class);

    public void init(ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps) {
        this.stateEventResponseService.init(processInstanceExecMaps);
    }

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.STATE_EVENT_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type: %s", command.getType()));
        StateEventChangeCommand stateEventChangeCommand = (StateEventChangeCommand)JSONUtils.parseObject((byte[])command.getBody(), StateEventChangeCommand.class);
        StateEvent stateEvent = new StateEvent();
        stateEvent.setKey(stateEventChangeCommand.getKey());
        if (stateEventChangeCommand.getSourceProcessInstanceId() != stateEventChangeCommand.getDestProcessInstanceId()) {
            stateEvent.setExecutionStatus(ExecutionStatus.RUNNING_EXECUTION);
        } else {
            stateEvent.setExecutionStatus(stateEventChangeCommand.getSourceStatus());
        }
        stateEvent.setProcessInstanceId(stateEventChangeCommand.getDestProcessInstanceId());
        stateEvent.setTaskInstanceId(stateEventChangeCommand.getDestTaskInstanceId());
        StateEventType type = stateEvent.getTaskInstanceId() == 0 ? StateEventType.PROCESS_STATE_CHANGE : StateEventType.TASK_STATE_CHANGE;
        stateEvent.setType(type);
        this.logger.info("received command : {}", (Object)stateEvent);
        this.stateEventResponseService.addResponse(stateEvent);
    }
}

