/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.runner.MasterExecService;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.hadoop.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateWheelExecuteThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(StateWheelExecuteThread.class);
    private ProcessService processService;
    private ConcurrentHashMap<Integer, ProcessInstance> processInstanceTimeoutCheckList;
    private ConcurrentHashMap<Integer, TaskInstance> taskInstanceTimeoutCheckList;
    private ConcurrentHashMap<Integer, TaskInstance> taskInstanceRetryCheckList;
    private ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps;
    private final ConcurrentHashMap<Integer, WorkflowExecuteThread> startProcessFailedMap;
    private int stateCheckIntervalSecs;
    private MasterExecService masterExecService;

    public StateWheelExecuteThread(MasterExecService masterExecService, ProcessService processService, ConcurrentHashMap<Integer, WorkflowExecuteThread> startProcessFailedMap, ConcurrentHashMap<Integer, ProcessInstance> processInstanceTimeoutCheckList, ConcurrentHashMap<Integer, TaskInstance> taskInstanceTimeoutCheckList, ConcurrentHashMap<Integer, TaskInstance> taskInstanceRetryCheckList, ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps, int stateCheckIntervalSecs) {
        this.masterExecService = masterExecService;
        this.processService = processService;
        this.startProcessFailedMap = startProcessFailedMap;
        this.processInstanceTimeoutCheckList = processInstanceTimeoutCheckList;
        this.taskInstanceTimeoutCheckList = taskInstanceTimeoutCheckList;
        this.taskInstanceRetryCheckList = taskInstanceRetryCheckList;
        this.processInstanceExecMaps = processInstanceExecMaps;
        this.stateCheckIntervalSecs = stateCheckIntervalSecs;
    }

    @Override
    public void run() {
        logger.info("state wheel thread start");
        while (Stopper.isRunning()) {
            try {
                this.check4StartProcessFailed();
                this.checkTask4Timeout();
                this.checkTask4Retry();
                this.checkProcess4Timeout();
            }
            catch (Exception e) {
                logger.error("state wheel thread check error:", (Throwable)e);
            }
            ThreadUtil.sleepAtLeastIgnoreInterrupts((long)this.stateCheckIntervalSecs);
        }
    }

    public void addProcess4TimeoutCheck(ProcessInstance processInstance) {
        this.processInstanceTimeoutCheckList.put(processInstance.getId(), processInstance);
    }

    public void addTask4TimeoutCheck(TaskInstance taskInstance) {
        this.taskInstanceTimeoutCheckList.put(taskInstance.getId(), taskInstance);
    }

    public void addTask4RetryCheck(TaskInstance taskInstance) {
        this.taskInstanceRetryCheckList.put(taskInstance.getId(), taskInstance);
    }

    public void checkTask4Timeout() {
        if (this.taskInstanceTimeoutCheckList.isEmpty()) {
            return;
        }
        for (TaskInstance taskInstance : this.taskInstanceTimeoutCheckList.values()) {
            long timeRemain;
            if (TimeoutFlag.OPEN != taskInstance.getTaskDefine().getTimeoutFlag()) continue;
            if (taskInstance.getStartTime() == null) {
                TaskInstance newTaskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstance.getId()));
                taskInstance.setStartTime(newTaskInstance.getStartTime());
            }
            if ((timeRemain = DateUtils.getRemainTime((Date)taskInstance.getStartTime(), (long)(taskInstance.getTaskDefine().getTimeout() * 60))) >= 0L) continue;
            this.addTaskTimeoutEvent(taskInstance);
            this.taskInstanceTimeoutCheckList.remove(taskInstance.getId());
        }
    }

    private void checkTask4Retry() {
        if (this.taskInstanceRetryCheckList.isEmpty()) {
            return;
        }
        for (TaskInstance taskInstance : this.taskInstanceRetryCheckList.values()) {
            if (!taskInstance.getState().typeIsFinished() && (taskInstance.isSubProcess() || taskInstance.isDependTask())) {
                this.addTaskStateChangeEvent(taskInstance);
                continue;
            }
            if (!taskInstance.taskCanRetry() || !taskInstance.retryTaskIntervalOverTime()) continue;
            this.addTaskStateChangeEvent(taskInstance);
            this.taskInstanceRetryCheckList.remove(taskInstance.getId());
        }
    }

    private void checkProcess4Timeout() {
        if (this.processInstanceTimeoutCheckList.isEmpty()) {
            return;
        }
        for (ProcessInstance processInstance : this.processInstanceTimeoutCheckList.values()) {
            long timeRemain = DateUtils.getRemainTime((Date)processInstance.getStartTime(), (long)(processInstance.getTimeout() * 60));
            if (timeRemain >= 0L) continue;
            this.addProcessTimeoutEvent(processInstance);
            this.processInstanceTimeoutCheckList.remove(processInstance.getId());
        }
    }

    private boolean addTaskStateChangeEvent(TaskInstance taskInstance) {
        StateEvent stateEvent = new StateEvent();
        stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
        stateEvent.setProcessInstanceId(taskInstance.getProcessInstanceId());
        stateEvent.setTaskInstanceId(taskInstance.getId());
        stateEvent.setExecutionStatus(ExecutionStatus.RUNNING_EXECUTION);
        this.addEvent(stateEvent);
        return true;
    }

    private boolean addTaskTimeoutEvent(TaskInstance taskInstance) {
        StateEvent stateEvent = new StateEvent();
        stateEvent.setType(StateEventType.TASK_TIMEOUT);
        stateEvent.setProcessInstanceId(taskInstance.getProcessInstanceId());
        stateEvent.setTaskInstanceId(taskInstance.getId());
        this.addEvent(stateEvent);
        return true;
    }

    private boolean addProcessTimeoutEvent(ProcessInstance processInstance) {
        StateEvent stateEvent = new StateEvent();
        stateEvent.setType(StateEventType.PROCESS_TIMEOUT);
        stateEvent.setProcessInstanceId(processInstance.getId());
        this.addEvent(stateEvent);
        return true;
    }

    private void addEvent(StateEvent stateEvent) {
        if (!this.processInstanceExecMaps.containsKey(stateEvent.getProcessInstanceId())) {
            return;
        }
        WorkflowExecuteThread workflowExecuteThread = this.processInstanceExecMaps.get(stateEvent.getProcessInstanceId());
        workflowExecuteThread.addStateEvent(stateEvent);
    }

    private void check4StartProcessFailed() {
        if (this.startProcessFailedMap.isEmpty()) {
            return;
        }
        for (WorkflowExecuteThread workflowExecuteThread : this.startProcessFailedMap.values()) {
            this.masterExecService.execute(workflowExecuteThread);
        }
    }
}

