/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWorker;

public class HostWeight {
    private final int CPU_FACTOR = 10;
    private final int MEMORY_FACTOR = 20;
    private final int LOAD_AVERAGE_FACTOR = 70;
    private final HostWorker hostWorker;
    private final double weight;
    private double currentWeight;

    public HostWeight(HostWorker hostWorker, double cpu, double memory, double loadAverage, long startTime) {
        this.hostWorker = hostWorker;
        this.currentWeight = this.weight = this.calculateWeight(cpu, memory, loadAverage, startTime);
    }

    public double getWeight() {
        return this.weight;
    }

    public double getCurrentWeight() {
        return this.currentWeight;
    }

    public void setCurrentWeight(double currentWeight) {
        this.currentWeight = currentWeight;
    }

    public HostWorker getHostWorker() {
        return this.hostWorker;
    }

    public Host getHost() {
        return this.hostWorker;
    }

    public String toString() {
        return "HostWeight{hostWorker=" + (Object)((Object)this.hostWorker) + ", weight=" + this.weight + ", currentWeight=" + this.currentWeight + '}';
    }

    private double calculateWeight(double cpu, double memory, double loadAverage, long startTime) {
        double calculatedWeight = cpu * 10.0 + memory * 20.0 + loadAverage * 70.0;
        long uptime = System.currentTimeMillis() - startTime;
        if (uptime > 0L && uptime < 600000L) {
            return calculatedWeight * 600000.0 / (double)uptime;
        }
        return calculatedWeight;
    }
}

