/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.sift.AbstractDiscriminator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLogDiscriminator
extends AbstractDiscriminator<ILoggingEvent> {
    private static Logger logger = LoggerFactory.getLogger(TaskLogDiscriminator.class);
    private String key;
    private String logBase;

    public String getDiscriminatingValue(ILoggingEvent event) {
        String key = "unknown_task";
        logger.debug("task log discriminator start, key is:{}, thread name:{},loggerName:{}", new Object[]{key, event.getThreadName(), event.getLoggerName()});
        if (event.getLoggerName().startsWith("TaskLogLogger")) {
            String prefix;
            String part1;
            String threadName = event.getThreadName();
            if (threadName.endsWith("-getOutputLogService")) {
                threadName = threadName.substring(0, threadName.length() - "-getOutputLogService".length());
            }
            if ((part1 = threadName.split("=")[1]).startsWith(prefix = "TASK-")) {
                key = part1.substring(prefix.length(), part1.length() - 1).replace("-", "/");
            }
        }
        logger.debug("task log discriminator end, key is:{}, thread name:{},loggerName:{}", new Object[]{key, event.getThreadName(), event.getLoggerName()});
        return key;
    }

    public void start() {
        this.started = true;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLogBase() {
        return this.logBase;
    }

    public void setLogBase(String logBase) {
        this.logBase = logBase;
    }
}

