/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.dolphinscheduler.rpc.base.RpcService;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceBean.class);
    private static Map<String, Class> serviceMap = new HashMap<String, Class>();
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    private ServiceBean() {
        throw new IllegalStateException("Utility class");
    }

    private static synchronized void init() {
        if (initialized.get()) {
            return;
        }
        Reflections f = new Reflections("org.apache.dolphinscheduler.", new Scanner[0]);
        ArrayList list = new ArrayList(f.getTypesAnnotatedWith(RpcService.class));
        list.forEach(rpcClass -> {
            RpcService rpcService = rpcClass.getAnnotation(RpcService.class);
            serviceMap.put(rpcService.value(), (Class)rpcClass);
            log.info("load rpc service {}", (Object)rpcService.value());
        });
        initialized.set(true);
    }

    public static Class getServiceClass(String className) {
        if (initialized.get()) {
            return serviceMap.get(className);
        }
        ServiceBean.init();
        return serviceMap.get(className);
    }
}

