/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.utils;

import java.io.Serializable;
import lombok.Generated;
import lombok.NonNull;

public class Host
implements Serializable {
    public static final Host EMPTY = new Host();
    private String ip;
    private int port;

    public Host() {
    }

    public Host(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public Host(String address) {
        int lastColonIndex = address.lastIndexOf(":");
        if (lastColonIndex < 0) {
            throw new IllegalArgumentException(String.format("Host : %s illegal.", address));
        }
        this.ip = address.substring(0, lastColonIndex);
        this.port = Integer.parseInt(address.substring(lastColonIndex + 1));
    }

    public String getAddress() {
        return this.ip + ":" + this.port;
    }

    public static Host of(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return new Host(address);
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Host)) {
            return false;
        }
        Host other = (Host)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Host;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Host(ip=" + this.getIp() + ", port=" + this.getPort() + ")";
    }
}

