/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.future;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.future.InvokeCallback;
import org.apache.dolphinscheduler.remote.future.ReleaseSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFuture {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponseFuture.class);
    private static final ConcurrentHashMap<Long, ResponseFuture> FUTURE_TABLE = new ConcurrentHashMap(256);
    private final long opaque;
    private final long timeoutMillis;
    private final InvokeCallback invokeCallback;
    private final ReleaseSemaphore releaseSemaphore;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final long beginTimestamp = System.currentTimeMillis();
    private Message responseMessage;
    private volatile boolean sendOk = true;
    private Throwable cause;

    public ResponseFuture(long opaque, long timeoutMillis, InvokeCallback invokeCallback, ReleaseSemaphore releaseSemaphore) {
        this.opaque = opaque;
        this.timeoutMillis = timeoutMillis;
        this.invokeCallback = invokeCallback;
        this.releaseSemaphore = releaseSemaphore;
        FUTURE_TABLE.put(opaque, this);
    }

    public Message waitResponse() throws InterruptedException {
        if (!this.latch.await(this.timeoutMillis, TimeUnit.MILLISECONDS)) {
            log.warn("Wait response timeout, request id {}", (Object)this.opaque);
        }
        return this.responseMessage;
    }

    public void putResponse(Message responseMessage) {
        this.responseMessage = responseMessage;
        this.latch.countDown();
        FUTURE_TABLE.remove(this.opaque);
    }

    public static ResponseFuture getFuture(long opaque) {
        return FUTURE_TABLE.get(opaque);
    }

    public void removeFuture() {
        FUTURE_TABLE.remove(this.opaque);
    }

    public boolean isTimeout() {
        long diff = System.currentTimeMillis() - this.beginTimestamp;
        return diff > this.timeoutMillis;
    }

    public void executeInvokeCallback() {
        if (this.invokeCallback != null) {
            this.invokeCallback.operationComplete(this);
        }
    }

    public boolean isSendOK() {
        return this.sendOk;
    }

    public void setSendOk(boolean sendOk) {
        this.sendOk = sendOk;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public long getBeginTimestamp() {
        return this.beginTimestamp;
    }

    public Message getResponseCommand() {
        return this.responseMessage;
    }

    public void setResponseCommand(Message responseMessage) {
        this.responseMessage = responseMessage;
    }

    public InvokeCallback getInvokeCallback() {
        return this.invokeCallback;
    }

    public void release() {
        if (this.releaseSemaphore != null) {
            this.releaseSemaphore.release();
        }
    }

    public static void scanFutureTable() {
        Iterator<Map.Entry<Long, ResponseFuture>> it = FUTURE_TABLE.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, ResponseFuture> next = it.next();
            ResponseFuture future = next.getValue();
            if (future.getBeginTimestamp() + future.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            try {
                future.release();
                future.executeInvokeCallback();
            }
            catch (Exception ex) {
                log.error("ScanFutureTable, execute callback error, requestId: {}", (Object)future.getOpaque(), (Object)ex);
            }
            it.remove();
            log.debug("Remove timeout request: {}", (Object)future);
        }
    }

    public String toString() {
        return "ResponseFuture{opaque=" + this.opaque + ", timeoutMillis=" + this.timeoutMillis + ", invokeCallback=" + this.invokeCallback + ", releaseSemaphore=" + this.releaseSemaphore + ", latch=" + this.latch + ", beginTimestamp=" + this.beginTimestamp + ", responseCommand=" + this.responseMessage + ", sendOk=" + this.sendOk + ", cause=" + this.cause + '}';
    }
}

