/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.dolphinscheduler.remote.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonSerializer.class);

    private JsonSerializer() {
    }

    public static <T> byte[] serialize(T obj) {
        String json = "";
        try {
            json = objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error("serializeToString exception!", (Throwable)e);
        }
        return json.getBytes(Constants.UTF8);
    }

    public static <T> String serializeToString(T obj) {
        String json = "";
        try {
            json = objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error("serializeToString exception!", (Throwable)e);
        }
        return json;
    }

    public static <T> T deserialize(byte[] src, Class<T> clazz) {
        String json = new String(src, StandardCharsets.UTF_8);
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            logger.error("deserialize exception!", (Throwable)e);
            return null;
        }
    }
}

