/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler;

import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.client.TaskExecutorClient;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.TaskLifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler.AbstractTaskLifecycleEventHandler;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.ITaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorLifecycleEventType;
import org.springframework.stereotype.Component;

@Component
public class TaskFailedLifecycleEventHandler
extends AbstractTaskLifecycleEventHandler<TaskFailedLifecycleEvent> {
    private final TaskExecutorClient taskExecutorClient;

    public TaskFailedLifecycleEventHandler(TaskExecutorClient taskExecutorClient) {
        this.taskExecutorClient = taskExecutorClient;
    }

    @Override
    public void handle(ITaskStateAction taskStateAction, IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskFailedLifecycleEvent event) {
        taskStateAction.onFailedEvent(workflowExecutionRunnable, taskExecutionRunnable, event);
        this.taskExecutorClient.ackTaskExecutorLifecycleEvent(taskExecutionRunnable, new ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck(taskExecutionRunnable.getId(), TaskExecutorLifecycleEventType.FAILED));
    }

    @Override
    public ILifecycleEventType matchEventType() {
        return TaskLifecycleEventType.FAILED;
    }
}

