/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.utils;

import com.google.common.collect.Maps;
import delight.nashornsandbox.NashornSandbox;
import delight.nashornsandbox.NashornSandboxes;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchTaskUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchTaskUtils.class);
    private static final NashornSandbox sandbox = NashornSandboxes.create();
    private static final String rgex = "['\"]*\\$\\{(.*?)\\}['\"]*";
    public static final String NASHORN_POLYFILL_ARRAY_PROTOTYPE_INCLUDES = "if (!Array.prototype.includes) {   Object.defineProperty(Array.prototype, 'includes', {       value: function(valueToFind, fromIndex) {           if (this == null) {               throw new TypeError('\"this\" is null or not defined');           }           var o = Object(this);           var len = o.length >>> 0;           if (len === 0) { return false; }           var n = fromIndex | 0;           var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);           function sameValueZero(x, y) {               return x === y || (typeof x === 'number' &&                    typeof y === 'number' && isNaN(x) && isNaN(y));           }           while (k < len) {               if (sameValueZero(o[k], valueToFind)) { return true; }               k++;           }           return false;       }   });}";

    public static boolean evaluate(String expression) throws ScriptException {
        Object result = sandbox.eval(expression);
        return Boolean.TRUE.equals(result);
    }

    public static String generateContentWithTaskParams(String condition, Map<String, Property> globalParams, Map<String, Property> varParams) {
        String content = condition.replaceAll("'", "\"");
        if (MapUtils.isEmpty(globalParams) && MapUtils.isEmpty(varParams)) {
            return content;
        }
        HashMap params = Maps.newHashMap();
        if (MapUtils.isNotEmpty(globalParams)) {
            params.putAll(globalParams);
        }
        if (MapUtils.isNotEmpty(varParams)) {
            params.putAll(varParams);
        }
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        while (m.find()) {
            String paramName = m.group(1);
            Property property = (Property)params.get(paramName);
            if (property == null) continue;
            String value = ParameterUtils.isNumber((Property)property) || ParameterUtils.isBoolean((Property)property) ? "" + ParameterUtils.getParameterValue((Property)property) : "\"" + ParameterUtils.getParameterValue((Property)property) + "\"";
            log.info("paramName:{}\uff0cparamValue:{}", (Object)paramName, (Object)value);
            content = content.replace("${" + paramName + "}", value);
        }
        return content;
    }

    static {
        try {
            sandbox.eval(NASHORN_POLYFILL_ARRAY_PROTOTYPE_INCLUDES);
        }
        catch (ScriptException e) {
            log.error("failed to load Nashorn polyfill", (Throwable)e);
        }
    }
}

