/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.runner.queue.DelayEntry;
import org.apache.dolphinscheduler.server.master.runner.queue.PriorityDelayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GlobalTaskDispatchWaitingQueue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalTaskDispatchWaitingQueue.class);
    private final Set<Integer> waitingTaskInstanceIds = ConcurrentHashMap.newKeySet();
    private final PriorityDelayQueue<DelayEntry<ITaskExecutionRunnable>> priorityDelayQueue = new PriorityDelayQueue();

    public synchronized void dispatchTaskExecuteRunnable(ITaskExecutionRunnable ITaskExecutionRunnable2) {
        this.dispatchTaskExecuteRunnableWithDelay(ITaskExecutionRunnable2, 0L);
    }

    public synchronized void dispatchTaskExecuteRunnableWithDelay(ITaskExecutionRunnable taskExecutionRunnable, long delayTimeMills) {
        this.waitingTaskInstanceIds.add(taskExecutionRunnable.getTaskInstance().getId());
        this.priorityDelayQueue.add(new DelayEntry<ITaskExecutionRunnable>(delayTimeMills, taskExecutionRunnable));
    }

    public ITaskExecutionRunnable takeTaskExecuteRunnable() {
        ITaskExecutionRunnable taskExecutionRunnable = this.priorityDelayQueue.take().getData();
        while (!this.markTaskExecutionRunnableRemoved(taskExecutionRunnable)) {
            taskExecutionRunnable = this.priorityDelayQueue.take().getData();
        }
        return taskExecutionRunnable;
    }

    public int getWaitingDispatchTaskNumber() {
        return this.waitingTaskInstanceIds.size();
    }

    public synchronized boolean markTaskExecutionRunnableRemoved(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.waitingTaskInstanceIds.remove(taskExecutionRunnable.getTaskInstance().getId());
    }
}

