/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.statemachine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.workflow.statemachine.IWorkflowStateAction;
import org.springframework.stereotype.Component;

@Component
public class WorkflowStateActionFactory {
    private final Map<WorkflowExecutionStatus, IWorkflowStateAction> workflowStateActionMap = new HashMap<WorkflowExecutionStatus, IWorkflowStateAction>();

    public WorkflowStateActionFactory(List<IWorkflowStateAction> workflowStateActions) {
        workflowStateActions.forEach(workflowStateAction -> this.workflowStateActionMap.put(workflowStateAction.matchState(), (IWorkflowStateAction)workflowStateAction));
        Arrays.stream(WorkflowExecutionStatus.values()).forEach(this::getAction);
    }

    public IWorkflowStateAction getAction(WorkflowExecutionStatus workflowExecutionStatus) {
        IWorkflowStateAction workflowStateAction = this.workflowStateActionMap.get(workflowExecutionStatus);
        if (workflowStateAction == null) {
            throw new IllegalArgumentException("Cannot find WorkflowStateAction for state: " + workflowExecutionStatus);
        }
        return workflowStateAction;
    }
}

