/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.statemachine;

import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailoverLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKillLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKilledLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPauseLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPausedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRetryLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRunningLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskSuccessLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.AbstractTaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.runner.GlobalTaskDispatchWaitingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskSubmittedStateAction
extends AbstractTaskStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskSubmittedStateAction.class);
    @Autowired
    private GlobalTaskDispatchWaitingQueue globalTaskDispatchWaitingQueue;
    @Autowired
    private TaskInstanceDao taskInstanceDao;

    @Override
    public void startEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskStartLifecycleEvent taskStartEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        if (workflowExecutionRunnable.isWorkflowReadyPause()) {
            workflowExecutionRunnable.getWorkflowEventBus().publish(TaskPausedLifecycleEvent.of(taskExecutionRunnable));
            return;
        }
        if (workflowExecutionRunnable.isWorkflowReadyStop()) {
            workflowExecutionRunnable.getWorkflowEventBus().publish(TaskKilledLifecycleEvent.of(taskExecutionRunnable));
            return;
        }
        this.tryToDispatchTask(taskExecutionRunnable);
    }

    @Override
    public void startedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskRunningLifecycleEvent taskRunningEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskRunningEvent);
    }

    @Override
    public void retryEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskRetryLifecycleEvent taskRetryEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskRetryEvent);
    }

    @Override
    public void dispatchEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskDispatchLifecycleEvent taskDispatchEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        long remainTimeMills = DateUtils.getRemainTime((Date)taskInstance.getFirstSubmitTime(), (long)((long)taskInstance.getDelayTime() * 60L)) * 1000L;
        if (remainTimeMills > 0L) {
            taskInstance.setState(TaskExecutionStatus.DELAY_EXECUTION);
            this.taskInstanceDao.updateById((Object)taskInstance);
            log.info("Current taskInstance: {} is choose delay execution, delay time: {}/min, remainTime: {}/ms", new Object[]{taskInstance.getName(), taskInstance.getDelayTime(), remainTimeMills});
        }
        this.globalTaskDispatchWaitingQueue.dispatchTaskExecuteRunnableWithDelay(taskExecutionRunnable, remainTimeMills);
    }

    @Override
    public void dispatchedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskDispatchedLifecycleEvent taskDispatchedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.dispatchedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskDispatchedEvent);
    }

    @Override
    public void pauseEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskPauseLifecycleEvent taskPauseEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        if (this.globalTaskDispatchWaitingQueue.markTaskExecutionRunnableRemoved(taskExecutionRunnable)) {
            log.info("Success pause task: {} before dispatch", (Object)taskExecutionRunnable.getName());
            taskExecutionRunnable.getWorkflowEventBus().publish(TaskPausedLifecycleEvent.of(taskExecutionRunnable));
            return;
        }
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskPauseEvent);
    }

    @Override
    public void pausedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskPausedLifecycleEvent taskPausedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.pausedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskPausedEvent);
    }

    @Override
    public void killEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskKillLifecycleEvent taskKillEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        if (this.globalTaskDispatchWaitingQueue.markTaskExecutionRunnableRemoved(taskExecutionRunnable)) {
            log.info("Success kill task: {} before dispatch", (Object)taskExecutionRunnable.getName());
            taskExecutionRunnable.getWorkflowEventBus().publish(TaskKilledLifecycleEvent.of(taskExecutionRunnable));
            return;
        }
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskKillEvent);
    }

    @Override
    public void killedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskKilledLifecycleEvent taskKilledEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.killedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskKilledEvent);
    }

    @Override
    public void failedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskFailedLifecycleEvent taskFailedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.failedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskFailedEvent);
    }

    @Override
    public void succeedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskSuccessLifecycleEvent taskSuccessEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskSuccessEvent);
    }

    @Override
    public void failoverEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskFailoverLifecycleEvent taskFailoverEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskFailoverEvent);
    }

    @Override
    public TaskExecutionStatus matchState() {
        return TaskExecutionStatus.SUBMITTED_SUCCESS;
    }
}

