/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.statemachine;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailoverLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKillLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKilledLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPauseLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPausedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRetryLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRunningLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskSuccessLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.AbstractTaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskFailureStateAction
extends AbstractTaskStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskFailureStateAction.class);

    @Override
    public void startEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskStartLifecycleEvent taskStartEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        TaskFailedLifecycleEvent taskFailedEvent = TaskFailedLifecycleEvent.builder().taskExecutionRunnable(taskExecutionRunnable).endTime(taskExecutionRunnable.getTaskInstance().getEndTime()).build();
        taskExecutionRunnable.getWorkflowEventBus().publish(taskFailedEvent);
    }

    @Override
    public void startedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskRunningLifecycleEvent taskRunningEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskRunningEvent);
    }

    @Override
    public void retryEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskRetryLifecycleEvent taskRetryEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        if (!taskExecutionRunnable.isTaskInstanceCanRetry()) {
            log.info("The task: {} cannot retry, because the retry times: {} is over the max retry times: {}", new Object[]{taskInstance.getName(), taskInstance.getRetryTimes(), taskInstance.getMaxRetryTimes()});
            return;
        }
        taskExecutionRunnable.retry();
    }

    @Override
    public void dispatchEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskDispatchLifecycleEvent taskDispatchEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskDispatchEvent);
    }

    @Override
    public void dispatchedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskDispatchedLifecycleEvent taskDispatchedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskDispatchedEvent);
    }

    @Override
    public void pauseEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskPauseLifecycleEvent taskPauseEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        if (this.isTaskRetrying(taskExecutionRunnable)) {
            super.pausedEventAction(workflowExecutionRunnable, taskExecutionRunnable, TaskPausedLifecycleEvent.of(taskExecutionRunnable));
            return;
        }
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskPauseEvent);
    }

    @Override
    public void pausedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskPausedLifecycleEvent taskPausedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        if (this.isTaskRetrying(taskExecutionRunnable)) {
            super.pausedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskPausedEvent);
            return;
        }
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskPausedEvent);
    }

    @Override
    public void killEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskKillLifecycleEvent taskKillEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        if (this.isTaskRetrying(taskExecutionRunnable)) {
            super.killedEventAction(workflowExecutionRunnable, taskExecutionRunnable, TaskKilledLifecycleEvent.of(taskExecutionRunnable));
            return;
        }
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskKillEvent);
    }

    @Override
    public void killedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskKilledLifecycleEvent taskKilledEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        if (this.isTaskRetrying(taskExecutionRunnable)) {
            super.killedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskKilledEvent);
            return;
        }
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskKilledEvent);
    }

    @Override
    public void failedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskFailedLifecycleEvent taskFailedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.failedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskFailedEvent);
    }

    @Override
    public void succeedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskSuccessLifecycleEvent taskSuccessEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskSuccessEvent);
    }

    @Override
    public void failoverEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskFailoverLifecycleEvent taskFailoverEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskFailoverEvent);
    }

    @Override
    public TaskExecutionStatus matchState() {
        return TaskExecutionStatus.FAILURE;
    }

    private boolean isTaskRetrying(ITaskExecutionRunnable taskExecutionRunnable) {
        IWorkflowExecutionGraph workflowExecutionGraph = taskExecutionRunnable.getWorkflowExecutionGraph();
        return workflowExecutionGraph.isTaskExecutionRunnableRetrying(taskExecutionRunnable);
    }
}

