/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.statemachine;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.task.client.TaskExecutorClient;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailoverLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKillLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKilledLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPauseLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPausedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRetryLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRunningLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskSuccessLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.AbstractTaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskDispatchStateAction
extends AbstractTaskStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskDispatchStateAction.class);
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private TaskExecutorClient taskExecutorClient;

    @Override
    public void startEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskStartLifecycleEvent taskStartEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        taskExecutionRunnable.getWorkflowEventBus().publish(TaskFailoverLifecycleEvent.of(taskExecutionRunnable));
    }

    @Override
    public void startedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskRunningLifecycleEvent taskRunningEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.persistentTaskInstanceStartedEventToDB(taskExecutionRunnable, taskRunningEvent);
    }

    @Override
    public void retryEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskRetryLifecycleEvent taskRetryEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskRetryEvent);
    }

    @Override
    public void dispatchEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskDispatchLifecycleEvent taskDispatchEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskDispatchEvent);
    }

    @Override
    public void dispatchedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskDispatchedLifecycleEvent taskDispatchedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.logWarningIfCannotDoAction(taskExecutionRunnable, taskDispatchedEvent);
    }

    @Override
    public void pauseEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskPauseLifecycleEvent taskPauseEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.taskExecutorClient.pause(taskExecutionRunnable);
    }

    @Override
    public void pausedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskPausedLifecycleEvent taskPausedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.pausedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskPausedEvent);
    }

    @Override
    public void killEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskKillLifecycleEvent taskKillEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        this.taskExecutorClient.kill(taskExecutionRunnable);
    }

    @Override
    public void killedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskKilledLifecycleEvent event) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.killedEventAction(workflowExecutionRunnable, taskExecutionRunnable, event);
    }

    @Override
    public void failedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskFailedLifecycleEvent taskFailedEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.failedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskFailedEvent);
    }

    @Override
    public void succeedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskSuccessLifecycleEvent taskSuccessEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.succeedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskSuccessEvent);
    }

    @Override
    public void failoverEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskFailoverLifecycleEvent taskFailoverEvent) {
        this.throwExceptionIfStateIsNotMatch(taskExecutionRunnable);
        super.failoverTask(taskExecutionRunnable);
    }

    @Override
    public TaskExecutionStatus matchState() {
        return TaskExecutionStatus.DISPATCH;
    }
}

