/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.runnable;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.task.client.ITaskExecutorClient;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKillLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPauseLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionContextCreateRequest;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionRunnableBuilder;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskInstanceFactories;
import org.apache.dolphinscheduler.server.master.runner.TaskExecutionContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TaskExecutionRunnable
implements ITaskExecutionRunnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionRunnable.class);
    private final ApplicationContext applicationContext;
    private final IWorkflowExecutionGraph workflowExecutionGraph;
    private final WorkflowEventBus workflowEventBus;
    private final WorkflowDefinition workflowDefinition;
    private final Project project;
    private final WorkflowInstance workflowInstance;
    @Nullable
    private TaskInstance taskInstance;
    private final TaskDefinition taskDefinition;
    private TaskExecutionContext taskExecutionContext;

    public TaskExecutionRunnable(TaskExecutionRunnableBuilder taskExecutionRunnableBuilder) {
        this.applicationContext = taskExecutionRunnableBuilder.getApplicationContext();
        this.workflowExecutionGraph = (IWorkflowExecutionGraph)Preconditions.checkNotNull((Object)taskExecutionRunnableBuilder.getWorkflowExecutionGraph());
        this.workflowEventBus = (WorkflowEventBus)((Object)Preconditions.checkNotNull((Object)((Object)taskExecutionRunnableBuilder.getWorkflowEventBus())));
        this.workflowDefinition = (WorkflowDefinition)Preconditions.checkNotNull((Object)taskExecutionRunnableBuilder.getWorkflowDefinition());
        this.project = (Project)Preconditions.checkNotNull((Object)taskExecutionRunnableBuilder.getProject());
        this.workflowInstance = (WorkflowInstance)Preconditions.checkNotNull((Object)taskExecutionRunnableBuilder.getWorkflowInstance());
        this.taskDefinition = (TaskDefinition)Preconditions.checkNotNull((Object)taskExecutionRunnableBuilder.getTaskDefinition());
        this.taskInstance = taskExecutionRunnableBuilder.getTaskInstance();
        if (this.isTaskInstanceInitialized()) {
            this.initializeTaskExecutionContext();
        }
    }

    @Override
    public boolean isTaskInstanceInitialized() {
        return this.taskInstance != null;
    }

    @Override
    public void initializeFirstRunTaskInstance() {
        Preconditions.checkState((!this.isTaskInstanceInitialized() ? 1 : 0) != 0, (Object)"The task instance is already initialized, can't initialize first run task.");
        this.taskInstance = ((TaskInstanceFactories)this.applicationContext.getBean(TaskInstanceFactories.class)).firstRunTaskInstanceFactory().builder().withTaskDefinition(this.taskDefinition).withWorkflowInstance(this.workflowInstance).build();
        this.initializeTaskExecutionContext();
    }

    @Override
    public boolean isTaskInstanceCanRetry() {
        return this.taskInstance.getRetryTimes() < this.taskInstance.getMaxRetryTimes();
    }

    @Override
    public void retry() {
        Preconditions.checkState((boolean)this.isTaskInstanceInitialized(), (Object)"The task instance is not initialized, can't initialize retry task.");
        this.taskInstance = ((TaskInstanceFactories)this.applicationContext.getBean(TaskInstanceFactories.class)).retryTaskInstanceFactory().builder().withTaskInstance(this.taskInstance).build();
        this.initializeTaskExecutionContext();
        this.getWorkflowEventBus().publish(TaskStartLifecycleEvent.of(this));
    }

    @Override
    public void failover() {
        Preconditions.checkState((boolean)this.isTaskInstanceInitialized(), (Object)"The task instance is not initialized, can't failover.");
        if (this.takeOverTaskFromExecutor()) {
            log.info("Failover task success, the task {} has been taken-over from executor", (Object)this.taskInstance.getName());
            return;
        }
        this.taskInstance = ((TaskInstanceFactories)this.applicationContext.getBean(TaskInstanceFactories.class)).failoverTaskInstanceFactory().builder().withTaskInstance(this.taskInstance).build();
        this.initializeTaskExecutionContext();
        this.getWorkflowEventBus().publish(TaskStartLifecycleEvent.of(this));
    }

    @Override
    public void pause() {
        this.getWorkflowEventBus().publish(TaskPauseLifecycleEvent.of(this));
    }

    @Override
    public void kill() {
        this.getWorkflowEventBus().publish(TaskKillLifecycleEvent.of(this));
    }

    private void initializeTaskExecutionContext() {
        Preconditions.checkState((boolean)this.isTaskInstanceInitialized(), (Object)"The task instance is null, can't initialize TaskExecutionContext.");
        TaskExecutionContextCreateRequest request = TaskExecutionContextCreateRequest.builder().workflowDefinition(this.workflowDefinition).project(this.project).workflowInstance(this.workflowInstance).taskDefinition(this.taskDefinition).taskInstance(this.taskInstance).build();
        this.taskExecutionContext = ((TaskExecutionContextFactory)this.applicationContext.getBean(TaskExecutionContextFactory.class)).createTaskExecutionContext(request);
    }

    private boolean takeOverTaskFromExecutor() {
        Preconditions.checkState((boolean)this.isTaskInstanceInitialized(), (Object)"The task instance is null, can't take over from executor.");
        try {
            return ((ITaskExecutorClient)this.applicationContext.getBean(ITaskExecutorClient.class)).reassignWorkflowInstanceHost(this);
        }
        catch (Exception ex) {
            log.warn("Take over task: {} failed", (Object)this.taskInstance.getName(), (Object)ex);
            return false;
        }
    }

    @Override
    public int compareTo(ITaskExecutionRunnable other) {
        if (other == null) {
            return 1;
        }
        int workflowInstancePriorityCompareResult = this.workflowInstance.getWorkflowInstancePriority().getCode() - other.getWorkflowInstance().getWorkflowInstancePriority().getCode();
        if (workflowInstancePriorityCompareResult != 0) {
            return workflowInstancePriorityCompareResult;
        }
        int taskInstancePriorityCompareResult = this.taskInstance.getTaskInstancePriority().getCode() - other.getTaskInstance().getTaskInstancePriority().getCode();
        if (taskInstancePriorityCompareResult != 0) {
            return taskInstancePriorityCompareResult;
        }
        int taskGroupPriorityCompareResult = this.taskInstance.getTaskGroupPriority() - other.getTaskInstance().getTaskGroupPriority();
        if (taskGroupPriorityCompareResult != 0) {
            return -taskGroupPriorityCompareResult;
        }
        return this.taskInstance.getFirstSubmitTime().compareTo(other.getTaskInstance().getFirstSubmitTime());
    }

    public String toString() {
        if (this.taskInstance != null) {
            return "TaskExecutionRunnable{name=" + this.getName() + ", state=" + this.taskInstance.getState() + '}';
        }
        return "TaskExecutionRunnable{name=" + this.getName() + '}';
    }

    @Override
    @Generated
    public IWorkflowExecutionGraph getWorkflowExecutionGraph() {
        return this.workflowExecutionGraph;
    }

    @Override
    @Generated
    public WorkflowEventBus getWorkflowEventBus() {
        return this.workflowEventBus;
    }

    @Generated
    public WorkflowDefinition getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Override
    @Generated
    public WorkflowInstance getWorkflowInstance() {
        return this.workflowInstance;
    }

    @Override
    @Nullable
    @Generated
    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    @Override
    @Generated
    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    @Override
    @Generated
    public TaskExecutionContext getTaskExecutionContext() {
        return this.taskExecutionContext;
    }
}

