/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.TaskLifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskTimeoutLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler.AbstractTaskLifecycleEventHandler;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.ITaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskStartLifecycleEventHandler
extends AbstractTaskLifecycleEventHandler<TaskStartLifecycleEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskStartLifecycleEventHandler.class);

    @Override
    public void handle(IWorkflowExecutionRunnable workflowExecutionRunnable, TaskStartLifecycleEvent taskStartLifecycleEvent) {
        ITaskExecutionRunnable taskExecutionRunnable = taskStartLifecycleEvent.getTaskExecutionRunnable();
        if (!taskExecutionRunnable.isTaskInstanceInitialized()) {
            taskExecutionRunnable.initializeFirstRunTaskInstance();
        }
        this.taskTimeoutMonitor(taskExecutionRunnable);
        super.handle(workflowExecutionRunnable, taskStartLifecycleEvent);
    }

    @Override
    public void handle(ITaskStateAction taskStateAction, IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskStartLifecycleEvent event) {
        taskStateAction.startEventAction(workflowExecutionRunnable, taskExecutionRunnable, event);
    }

    @Override
    public ILifecycleEventType matchEventType() {
        return TaskLifecycleEventType.START;
    }

    private void taskTimeoutMonitor(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskDefinition taskDefinition = taskExecutionRunnable.getTaskDefinition();
        if (taskDefinition.getTimeout() <= 0) {
            log.debug("The task {} timeout {} is invalided, so the timeout monitor will not be started.", (Object)taskDefinition.getName(), (Object)taskDefinition.getTimeout());
            return;
        }
        taskExecutionRunnable.getWorkflowEventBus().publish(TaskTimeoutLifecycleEvent.of(taskExecutionRunnable));
    }
}

