/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.command.handler;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.master.command.WorkflowFailoverCommandParam;
import org.apache.dolphinscheduler.server.master.engine.ITaskGroupCoordinator;
import org.apache.dolphinscheduler.server.master.engine.command.handler.AbstractCommandHandler;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.WorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.WorkflowGraphTopologyLogicalVisitor;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionRunnableBuilder;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class WorkflowFailoverCommandHandler
extends AbstractCommandHandler {
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private ITaskGroupCoordinator taskGroupCoordinator;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    protected void assembleWorkflowInstance(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        Command command = workflowExecuteContextBuilder.getCommand();
        int workflowInstanceId = command.getWorkflowInstanceId();
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryOptionalById((Serializable)Integer.valueOf(workflowInstanceId)).orElseThrow(() -> new IllegalArgumentException("Cannot find WorkflowInstance:" + workflowInstanceId));
        WorkflowFailoverCommandParam workflowFailoverCommandParam = (WorkflowFailoverCommandParam)JSONUtils.parseObject((String)command.getCommandParam(), WorkflowFailoverCommandParam.class);
        if (workflowFailoverCommandParam == null) {
            throw new IllegalArgumentException("The WorkflowFailoverCommandParam: " + command.getCommandParam() + " is invalid");
        }
        workflowInstance.setState(workflowFailoverCommandParam.getWorkflowExecutionStatus());
        this.workflowInstanceDao.updateById((Object)workflowInstance);
        workflowExecuteContextBuilder.setWorkflowInstance(workflowInstance);
    }

    @Override
    protected void assembleWorkflowExecutionGraph(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        Map taskInstanceMap = this.getValidTaskInstance(workflowExecuteContextBuilder.getWorkflowInstance()).stream().collect(Collectors.toMap(TaskInstance::getName, Function.identity()));
        IWorkflowGraph workflowGraph = workflowExecuteContextBuilder.getWorkflowGraph();
        WorkflowExecutionGraph workflowExecutionGraph = new WorkflowExecutionGraph();
        BiConsumer<String, Set<String>> taskExecutionRunnableCreator = (task, successors) -> {
            TaskExecutionRunnableBuilder taskExecutionRunnableBuilder = TaskExecutionRunnableBuilder.builder().workflowExecutionGraph(workflowExecutionGraph).workflowDefinition(workflowExecuteContextBuilder.getWorkflowDefinition()).project(workflowExecuteContextBuilder.getProject()).workflowInstance(workflowExecuteContextBuilder.getWorkflowInstance()).taskDefinition(workflowGraph.getTaskNodeByName((String)task)).taskInstance((TaskInstance)taskInstanceMap.get(task)).workflowEventBus(workflowExecuteContextBuilder.getWorkflowEventBus()).applicationContext(this.applicationContext).build();
            workflowExecutionGraph.addNode(new TaskExecutionRunnable(taskExecutionRunnableBuilder));
            workflowExecutionGraph.addEdge((String)task, (Set<String>)successors);
        };
        WorkflowGraphTopologyLogicalVisitor workflowGraphTopologyLogicalVisitor = WorkflowGraphTopologyLogicalVisitor.builder().taskDependType(workflowExecuteContextBuilder.getWorkflowInstance().getTaskDependType()).onWorkflowGraph(workflowGraph).fromTask(this.parseStartNodesFromWorkflowInstance(workflowExecuteContextBuilder)).doVisitFunction(taskExecutionRunnableCreator).build();
        workflowGraphTopologyLogicalVisitor.visit();
        workflowExecuteContextBuilder.setWorkflowExecutionGraph(workflowExecutionGraph);
    }

    @Override
    public CommandType commandType() {
        return CommandType.RECOVER_TOLERANCE_FAULT_PROCESS;
    }
}

