/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.ssh.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.text.MessageFormat;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.ssh.SshClientWrapper;
import org.apache.dolphinscheduler.plugin.datasource.ssh.param.SSHConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.ssh.param.SSHDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class SSHDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SSHDataSourceProcessor.class);

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, SSHDataSourceParamDTO.class);
    }

    public void checkDatasourceParam(BaseDataSourceParamDTO datasourceParamDTO) {
        if (StringUtils.isEmpty((CharSequence)datasourceParamDTO.getHost()) || StringUtils.isEmpty((CharSequence)datasourceParamDTO.getUserName())) {
            throw new IllegalArgumentException("ssh datasource param is not valid");
        }
    }

    public String getDatasourceUniqueId(ConnectionParam connectionParam, DbType dbType) {
        SSHConnectionParam baseConnectionParam = (SSHConnectionParam)connectionParam;
        return MessageFormat.format("{0}@{1}@{2}@{3}", dbType.getName(), baseConnectionParam.getHost(), baseConnectionParam.getUser(), PasswordUtils.encodePassword((String)baseConnectionParam.getPassword()));
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        SSHConnectionParam connectionParams = (SSHConnectionParam)this.createConnectionParams(connectionJson);
        SSHDataSourceParamDTO sshDataSourceParamDTO = new SSHDataSourceParamDTO();
        sshDataSourceParamDTO.setUserName(connectionParams.getUser());
        sshDataSourceParamDTO.setPassword(connectionParams.getPassword());
        sshDataSourceParamDTO.setHost(connectionParams.getHost());
        sshDataSourceParamDTO.setPort(connectionParams.getPort());
        sshDataSourceParamDTO.setPublicKey(connectionParams.getPublicKey());
        return sshDataSourceParamDTO;
    }

    public SSHConnectionParam createConnectionParams(BaseDataSourceParamDTO dataSourceParam) {
        SSHDataSourceParamDTO sshDataSourceParam = (SSHDataSourceParamDTO)dataSourceParam;
        SSHConnectionParam sshConnectionParam = new SSHConnectionParam();
        sshConnectionParam.setUser(sshDataSourceParam.getUserName());
        sshConnectionParam.setPassword(sshDataSourceParam.getPassword());
        sshConnectionParam.setHost(sshDataSourceParam.getHost());
        sshConnectionParam.setPort(sshDataSourceParam.getPort());
        sshConnectionParam.setPublicKey(sshDataSourceParam.getPublicKey());
        return sshConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, SSHConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "";
    }

    public String getValidationQuery() {
        return "";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        return "";
    }

    public Connection getConnection(ConnectionParam connectionParam) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(ConnectionParam connectionParam) {
        SSHConnectionParam baseConnectionParam = (SSHConnectionParam)connectionParam;
        try (SshClientWrapper sshClientWrapper = new SshClientWrapper(baseConnectionParam.getHost(), baseConnectionParam.getPort(), baseConnectionParam.getUser(), baseConnectionParam.getPassword(), baseConnectionParam.getPublicKey());){
            boolean bl = sshClientWrapper.isAuth();
            return bl;
        }
        catch (Exception e) {
            log.error("ssh test connection failed", (Throwable)e);
            return false;
        }
    }

    public DbType getDbType() {
        return DbType.SSH;
    }

    public DataSourceProcessor create() {
        return new SSHDataSourceProcessor();
    }
}

