/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.ssh;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.time.Duration;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshClientWrapper
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshClientWrapper.class);
    private SshClient sshClient;
    private final ClientSession clientSession;

    public SshClientWrapper(String ip, Integer port, String userName, String password, String privateKey) throws IOException, GeneralSecurityException {
        Preconditions.checkNotNull((Object)ip);
        Preconditions.checkNotNull((Object)port);
        Preconditions.checkNotNull((Object)userName);
        this.clientSession = this.createSession(ip, port, userName);
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            this.clientSession.addPasswordIdentity(password);
        }
        if (StringUtils.isNotEmpty((CharSequence)privateKey)) {
            KeyPairResourceParser loader = SecurityUtils.getKeyPairResourceParser();
            Collection keyPairCollection = loader.loadKeyPairs(null, null, null, privateKey);
            for (KeyPair keyPair : keyPairCollection) {
                this.clientSession.addPublicKeyIdentity(keyPair);
            }
        }
    }

    public boolean isAuth() throws IOException {
        return ((AuthFuture)this.clientSession.auth().verify(Duration.ofSeconds(10L))).isSuccess();
    }

    private ClientSession createSession(String ip, Integer port, String userName) throws IOException {
        this.sshClient = SshClient.setUpDefaultClient();
        this.sshClient.start();
        return (ClientSession)((ConnectFuture)this.sshClient.connect(userName, ip, port.intValue()).verify(Duration.ofSeconds(10L))).getSession();
    }

    @Override
    public void close() throws Exception {
        try (ClientSession clientSession1 = this.clientSession;){
            SshClient sshClient1 = this.sshClient;
            Throwable throwable = null;
            if (sshClient1 != null) {
                if (throwable != null) {
                    try {
                        sshClient1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    sshClient1.close();
                }
            }
        }
    }
}

