/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.spark.param;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.CommonUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.spark.param.SparkConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.spark.param.SparkDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class SparkDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, SparkDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        SparkConnectionParam connectionParams = (SparkConnectionParam)this.createConnectionParams(connectionJson);
        SparkDataSourceParamDTO sparkDatasourceParamDTO = new SparkDataSourceParamDTO();
        sparkDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        sparkDatasourceParamDTO.setUserName(connectionParams.getUser());
        sparkDatasourceParamDTO.setOther(connectionParams.getOther());
        sparkDatasourceParamDTO.setJavaSecurityKrb5Conf(connectionParams.getJavaSecurityKrb5Conf());
        sparkDatasourceParamDTO.setLoginUserKeytabPath(connectionParams.getLoginUserKeytabPath());
        sparkDatasourceParamDTO.setLoginUserKeytabUsername(connectionParams.getLoginUserKeytabUsername());
        sparkDatasourceParamDTO.setPrincipal(connectionParams.getPrincipal());
        StringBuilder hosts = new StringBuilder();
        String[] tmpArray = connectionParams.getAddress().split("//");
        String[] hostPortArray = tmpArray[tmpArray.length - 1].split(",");
        Arrays.stream(hostPortArray).forEach(hostPort -> hosts.append(hostPort.split(":")[0]).append(","));
        hosts.deleteCharAt(hosts.length() - 1);
        sparkDatasourceParamDTO.setHost(hosts.toString());
        sparkDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        return sparkDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO dataSourceParam) {
        StringBuilder address = new StringBuilder();
        SparkDataSourceParamDTO sparkDatasourceParam = (SparkDataSourceParamDTO)dataSourceParam;
        address.append("jdbc:hive2://");
        for (String zkHost : sparkDatasourceParam.getHost().split(",")) {
            address.append(String.format("%s:%s,", zkHost, sparkDatasourceParam.getPort()));
        }
        address.deleteCharAt(address.length() - 1);
        String jdbcUrl = address + "/" + sparkDatasourceParam.getDatabase();
        SparkConnectionParam sparkConnectionParam = new SparkConnectionParam();
        sparkConnectionParam.setPassword(PasswordUtils.encodePassword((String)sparkDatasourceParam.getPassword()));
        sparkConnectionParam.setUser(sparkDatasourceParam.getUserName());
        sparkConnectionParam.setOther(sparkDatasourceParam.getOther());
        sparkConnectionParam.setDatabase(sparkDatasourceParam.getDatabase());
        sparkConnectionParam.setAddress(address.toString());
        sparkConnectionParam.setJdbcUrl(jdbcUrl);
        sparkConnectionParam.setDriverClassName(this.getDatasourceDriver());
        sparkConnectionParam.setValidationQuery(this.getValidationQuery());
        if (CommonUtils.getKerberosStartupState()) {
            sparkConnectionParam.setPrincipal(sparkDatasourceParam.getPrincipal());
            sparkConnectionParam.setJavaSecurityKrb5Conf(sparkDatasourceParam.getJavaSecurityKrb5Conf());
            sparkConnectionParam.setLoginUserKeytabPath(sparkDatasourceParam.getLoginUserKeytabPath());
            sparkConnectionParam.setLoginUserKeytabUsername(sparkDatasourceParam.getLoginUserKeytabUsername());
        }
        return sparkConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, SparkConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "org.apache.hive.jdbc.HiveDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        SparkConnectionParam sparkConnectionParam = (SparkConnectionParam)connectionParam;
        StringBuilder jdbcUrlBuilder = new StringBuilder(sparkConnectionParam.getJdbcUrl());
        if (StringUtils.isNotBlank((CharSequence)sparkConnectionParam.getPrincipal())) {
            jdbcUrlBuilder.append(";principal=").append(sparkConnectionParam.getPrincipal());
        }
        if (MapUtils.isNotEmpty((Map)sparkConnectionParam.getOther())) {
            jdbcUrlBuilder.append(";").append(this.transformOther(sparkConnectionParam.getOther()));
        }
        return jdbcUrlBuilder.toString();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws IOException, ClassNotFoundException, SQLException {
        SparkConnectionParam sparkConnectionParam = (SparkConnectionParam)connectionParam;
        CommonUtils.loadKerberosConf((String)sparkConnectionParam.getJavaSecurityKrb5Conf(), (String)sparkConnectionParam.getLoginUserKeytabUsername(), (String)sparkConnectionParam.getLoginUserKeytabPath());
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl((ConnectionParam)sparkConnectionParam), sparkConnectionParam.getUser(), PasswordUtils.decodePassword((String)sparkConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.SPARK;
    }

    public DataSourceProcessor create() {
        return new SparkDataSourceProcessor();
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        List stringBuilder = otherMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.toList());
        return String.join((CharSequence)";", stringBuilder);
    }
}

