/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.k8s.param;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.k8s.K8sClientWrapper;
import org.apache.dolphinscheduler.plugin.datasource.k8s.param.K8sConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.k8s.param.K8sDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class K8sDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sDataSourceProcessor.class);

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, K8sDataSourceParamDTO.class);
    }

    public void checkDatasourceParam(BaseDataSourceParamDTO datasourceParam) {
        K8sDataSourceParamDTO k8sDataSourceParamDTO = (K8sDataSourceParamDTO)datasourceParam;
        if (StringUtils.isEmpty((CharSequence)k8sDataSourceParamDTO.getKubeConfig())) {
            throw new IllegalArgumentException("sagemaker datasource param is not valid");
        }
    }

    public String getDatasourceUniqueId(ConnectionParam connectionParam, DbType dbType) {
        K8sConnectionParam baseConnectionParam = (K8sConnectionParam)connectionParam;
        return MessageFormat.format("{0}@{1}@{2}", dbType.getName(), PasswordUtils.encodePassword((String)baseConnectionParam.getKubeConfig()), baseConnectionParam.getNamespace());
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        K8sConnectionParam connectionParams = (K8sConnectionParam)this.createConnectionParams(connectionJson);
        K8sDataSourceParamDTO k8sDataSourceParamDTO = new K8sDataSourceParamDTO();
        k8sDataSourceParamDTO.setKubeConfig(connectionParams.getKubeConfig());
        k8sDataSourceParamDTO.setNamespace(connectionParams.getNamespace());
        return k8sDataSourceParamDTO;
    }

    public K8sConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        K8sDataSourceParamDTO k8sDataSourceParam = (K8sDataSourceParamDTO)datasourceParam;
        K8sConnectionParam k8sConnectionParam = new K8sConnectionParam();
        k8sConnectionParam.setKubeConfig(k8sDataSourceParam.getKubeConfig());
        k8sConnectionParam.setNamespace(k8sDataSourceParam.getNamespace());
        return k8sConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, K8sConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "";
    }

    public String getValidationQuery() {
        return "";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        return "";
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException, IOException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(ConnectionParam connectionParam) {
        K8sConnectionParam baseConnectionParam = (K8sConnectionParam)connectionParam;
        try (K8sClientWrapper k8sClientWrapper = new K8sClientWrapper();){
            boolean bl = k8sClientWrapper.checkConnect(baseConnectionParam.kubeConfig, baseConnectionParam.namespace);
            return bl;
        }
        catch (Exception e) {
            log.error("failed to connect to the K8S cluster", (Throwable)e);
            return false;
        }
    }

    public DbType getDbType() {
        return DbType.K8S;
    }

    public DataSourceProcessor create() {
        return new K8sDataSourceProcessor();
    }
}

