/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.lifecycle;

import lombok.Generated;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleException;
import org.apache.dolphinscheduler.common.lifecycle.ServerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerLifeCycleManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerLifeCycleManager.class);
    private static volatile ServerStatus serverStatus = ServerStatus.RUNNING;
    private static long serverStartupTime = System.currentTimeMillis();

    public static long getServerStartupTime() {
        return serverStartupTime;
    }

    public static void toRunning() {
        serverStatus = ServerStatus.RUNNING;
    }

    public static boolean isRunning() {
        return serverStatus == ServerStatus.RUNNING;
    }

    public static boolean isStopped() {
        return serverStatus == ServerStatus.STOPPED;
    }

    public static ServerStatus getServerStatus() {
        return serverStatus;
    }

    public static synchronized void toWaiting() throws ServerLifeCycleException {
        if (ServerLifeCycleManager.isStopped()) {
            throw new ServerLifeCycleException("The current server is already stopped, cannot change to waiting");
        }
        if (serverStatus == ServerStatus.WAITING) {
            log.warn("The current server is already at waiting status, cannot change to waiting");
            return;
        }
        serverStatus = ServerStatus.WAITING;
    }

    public static synchronized void recoverFromWaiting() throws ServerLifeCycleException {
        if (ServerLifeCycleManager.isStopped()) {
            throw new ServerLifeCycleException("The current server is already stopped, cannot recovery");
        }
        if (serverStatus == ServerStatus.RUNNING) {
            log.warn("The current server status is already running, cannot recover form waiting");
            return;
        }
        serverStartupTime = System.currentTimeMillis();
        serverStatus = ServerStatus.RUNNING;
    }

    public static synchronized boolean toStopped() {
        if (serverStatus == ServerStatus.STOPPED) {
            return false;
        }
        log.info("The current server status changed from {} to {}", (Object)serverStatus, (Object)ServerStatus.STOPPED);
        serverStatus = ServerStatus.STOPPED;
        return true;
    }

    @Generated
    private ServerLifeCycleManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

