/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;
import lombok.Generated;

public enum WorkflowExecutionTypeEnum {
    PARALLEL(0, "parallel"),
    SERIAL_WAIT(1, "serial wait"),
    SERIAL_DISCARD(2, "serial discard"),
    SERIAL_PRIORITY(3, "serial priority");

    @EnumValue
    private final int code;
    private final String descp;
    private static HashMap<Integer, WorkflowExecutionTypeEnum> EXECUTION_STATUS_MAP;

    private WorkflowExecutionTypeEnum(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static WorkflowExecutionTypeEnum of(int executionType) {
        if (EXECUTION_STATUS_MAP.containsKey(executionType)) {
            return EXECUTION_STATUS_MAP.get(executionType);
        }
        throw new IllegalArgumentException("invalid status : " + executionType);
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getDescp() {
        return this.descp;
    }

    static {
        EXECUTION_STATUS_MAP = new HashMap();
        for (WorkflowExecutionTypeEnum executionType : WorkflowExecutionTypeEnum.values()) {
            EXECUTION_STATUS_MAP.put(executionType.code, executionType);
        }
    }
}

