/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public enum WorkflowExecutionStatus {
    SUBMITTED_SUCCESS(0, "submitted"),
    RUNNING_EXECUTION(1, "running"),
    READY_PAUSE(2, "ready pause"),
    PAUSE(3, "pause"),
    READY_STOP(4, "ready stop"),
    STOP(5, "stop"),
    FAILURE(6, "failure"),
    SUCCESS(7, "success"),
    SERIAL_WAIT(14, "serial wait"),
    FAILOVER(18, "failover");

    private static final Map<Integer, WorkflowExecutionStatus> CODE_MAP;
    private static final int[] NEED_FAILOVER_STATES;
    private static final int[] NOT_TERMINAL_STATUS;
    @EnumValue
    private final int code;
    private final String desc;

    @NonNull
    public static WorkflowExecutionStatus of(int code) {
        WorkflowExecutionStatus workflowExecutionStatus = CODE_MAP.get(code);
        if (workflowExecutionStatus == null) {
            throw new IllegalArgumentException(String.format("The workflow execution status code: %s is invalidated", code));
        }
        return workflowExecutionStatus;
    }

    public boolean isRunning() {
        return this == RUNNING_EXECUTION;
    }

    public boolean canStop() {
        return this == RUNNING_EXECUTION || this == READY_PAUSE || this == READY_STOP || this == SERIAL_WAIT;
    }

    public boolean canDirectStopInDB() {
        return this == SERIAL_WAIT;
    }

    public boolean canPause() {
        return this == RUNNING_EXECUTION || this == READY_PAUSE || this == SERIAL_WAIT;
    }

    public boolean canDirectPauseInDB() {
        return this == SERIAL_WAIT;
    }

    public boolean isFinished() {
        return this.isSuccess() || this.isFailure() || this.isStop() || this.isPause();
    }

    public boolean isSuccess() {
        return this == SUCCESS;
    }

    public boolean isFailure() {
        return this == FAILURE;
    }

    public boolean isPause() {
        return this == PAUSE;
    }

    public boolean isReadyStop() {
        return this == READY_STOP;
    }

    public boolean isStop() {
        return this == STOP;
    }

    public static int[] getNeedFailoverWorkflowInstanceState() {
        return NEED_FAILOVER_STATES;
    }

    public static int[] getNotTerminalStatus() {
        return NOT_TERMINAL_STATUS;
    }

    private WorkflowExecutionStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String toString() {
        return this.name();
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_MAP = new HashMap<Integer, WorkflowExecutionStatus>();
        NEED_FAILOVER_STATES = new int[]{RUNNING_EXECUTION.getCode(), READY_PAUSE.getCode(), READY_STOP.getCode()};
        NOT_TERMINAL_STATUS = new int[]{SUBMITTED_SUCCESS.getCode(), RUNNING_EXECUTION.getCode(), READY_PAUSE.getCode(), READY_STOP.getCode(), SERIAL_WAIT.getCode()};
        for (WorkflowExecutionStatus executionStatus : WorkflowExecutionStatus.values()) {
            CODE_MAP.put(executionStatus.getCode(), executionStatus);
        }
    }
}

