/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.CreateFileFromContentDto;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class CreateFileFromContentDtoValidator
extends AbstractResourceValidator<CreateFileFromContentDto> {
    public CreateFileFromContentDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(CreateFileFromContentDto createFileFromContentDto) {
        String fileAbsolutePath = createFileFromContentDto.getFileAbsolutePath();
        User loginUser = createFileFromContentDto.getLoginUser();
        String fileContent = createFileFromContentDto.getFileContent();
        this.exceptionResourceAbsolutePathInvalidated(fileAbsolutePath);
        this.exceptionResourceIsNotFile(fileAbsolutePath);
        this.exceptionResourceExists(fileAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, fileAbsolutePath);
        this.exceptionFileContentInvalidated(fileContent);
    }
}

