/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.logging;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.common.ILogService;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadRequest;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadResponse;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryRequest;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LocalLogClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalLogClient.class);

    public TaskInstanceLogFileDownloadResponse getWholeLog(TaskInstance taskInstance) {
        return this.getLocalWholeLog(taskInstance);
    }

    public TaskInstanceLogPageQueryResponse getPartLog(TaskInstance taskInstance, int skipLineNum, int limit) {
        return this.getLocalPartLog(taskInstance, skipLineNum, limit);
    }

    private TaskInstanceLogFileDownloadResponse getLocalWholeLog(TaskInstance taskInstance) {
        TaskInstanceLogFileDownloadRequest request = new TaskInstanceLogFileDownloadRequest((long)taskInstance.getId().intValue(), taskInstance.getLogPath());
        return this.getProxyLogService(taskInstance).getTaskInstanceWholeLogFileBytes(request);
    }

    private TaskInstanceLogPageQueryResponse getLocalPartLog(TaskInstance taskInstance, int skipLineNum, int limit) {
        TaskInstanceLogPageQueryRequest request = TaskInstanceLogPageQueryRequest.builder().taskInstanceId(taskInstance.getId()).taskInstanceLogAbsolutePath(taskInstance.getLogPath()).skipLineNum(skipLineNum).limit(limit).build();
        return this.getProxyLogService(taskInstance).pageQueryTaskInstanceLog(request);
    }

    private ILogService getProxyLogService(TaskInstance taskInstance) {
        ILogService logService = (ILogService)Clients.withService(ILogService.class).withHost(taskInstance.getHost());
        log.debug("Created log service for host: {}", (Object)taskInstance.getHost());
        return logService;
    }
}

