/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit.operator.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.audit.OperatorUtils;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.audit.operator.BaseAuditOperator;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleAuditOperatorImpl
extends BaseAuditOperator {
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;

    @Override
    public void modifyRequestParams(String[] paramNameArr, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        if (!paramNameArr[0].equals("id")) {
            return;
        }
        int id = (Integer)paramsMap.get(paramNameArr[0]);
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)Integer.valueOf(id));
        if (schedule != null) {
            paramsMap.put("code", schedule.getWorkflowDefinitionCode());
            paramNameArr[0] = "code";
            auditLogList.forEach(auditLog -> auditLog.setDetail(String.valueOf(id)));
        }
    }

    @Override
    protected void setObjectIdentityFromReturnObject(AuditType auditType, Result<?> result, List<AuditLog> auditLogList) {
        String[] returnObjectFieldNameArr = auditType.getReturnObjectFieldName();
        if (returnObjectFieldNameArr.length == 0) {
            return;
        }
        Map<String, Object> returnObjectMap = OperatorUtils.getObjectIfFromReturnObject(result.getData(), returnObjectFieldNameArr);
        auditLogList.forEach(auditLog -> auditLog.setDetail(returnObjectMap.get(returnObjectFieldNameArr[0]).toString()));
    }

    @Override
    protected String getObjectNameFromIdentity(Object identity) {
        Long objId = this.toLong(identity);
        if (objId == -1L) {
            return "";
        }
        WorkflowDefinition obj = this.workflowDefinitionMapper.queryByCode(objId.longValue());
        return obj == null ? "" : obj.getName();
    }
}

