/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.WorkflowLineageService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.DependentLineageTask;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkFlowLineage;
import org.apache.dolphinscheduler.dao.entity.WorkFlowRelationDetail;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="WORK_FLOW_LINEAGE_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/lineages"})
public class WorkflowLineageController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowLineageController.class);
    @Autowired
    private WorkflowLineageService workflowLineageService;

    @Operation(summary="queryLineageByWorkFlowName", description="QUERY_WORKFLOW_LINEAGE_BY_NAME_NOTES")
    @GetMapping(value={"/query-by-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKFLOW_LINEAGE_ERROR)
    public Result<List<WorkFlowRelationDetail>> queryWorkFlowLineageByName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="workflowDefinitionName", required=false) String workflowDefinitionName) {
        workflowDefinitionName = ParameterUtils.handleEscapes((String)workflowDefinitionName);
        List<WorkFlowRelationDetail> workFlowLineages = this.workflowLineageService.queryWorkFlowLineageByName(projectCode, workflowDefinitionName);
        return Result.success(workFlowLineages);
    }

    @Operation(summary="queryLineageByWorkFlowCode", description="QUERY_WORKFLOW_LINEAGE_BY_CODE_NOTE")
    @GetMapping(value={"/{workFlowCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKFLOW_LINEAGE_ERROR)
    public Result<Map<String, Object>> queryWorkFlowLineageByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="workFlowCode") long workFlowCode) {
        WorkFlowLineage workFlowLineage = this.workflowLineageService.queryWorkFlowLineageByCode(projectCode, workFlowCode);
        HashMap<String, WorkFlowLineage> result = new HashMap<String, WorkFlowLineage>();
        result.put("data", workFlowLineage);
        return Result.success(result);
    }

    @Operation(summary="queryWorkFlowList", description="QUERY_WORKFLOW_LINEAGE_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result<Map<String, Object>> queryWorkFlowLineage(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        try {
            HashMap<String, WorkFlowLineage> result = new HashMap<String, WorkFlowLineage>();
            WorkFlowLineage workFlowLineage = this.workflowLineageService.queryWorkFlowLineage(projectCode);
            result.put("data", workFlowLineage);
            return Result.success(result);
        }
        catch (Exception e) {
            log.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getCode(), Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg());
        }
    }

    @Operation(summary="verifyTaskCanDelete", description="VERIFY_TASK_CAN_DELETE")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="workflowDefinitionCode", description="WORKFLOW_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskCode", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789"))})
    @PostMapping(value={"/tasks/verify-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.TASK_WITH_DEPENDENT_ERROR)
    public Result<Map<String, Object>> verifyTaskCanDelete(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="workflowDefinitionCode") long workflowDefinitionCode, @RequestParam(value="taskCode") long taskCode) {
        Result<Map<String, Object>> result = new Result<Map<String, Object>>();
        Optional<String> taskDepMsg = this.workflowLineageService.taskDependentMsg(projectCode, workflowDefinitionCode, taskCode);
        if (taskDepMsg.isPresent()) {
            throw new ServiceException(taskDepMsg.get());
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Operation(summary="verifyTaskCanDelete", description="VERIFY_TASK_CAN_DELETE")
    @Parameters(value={@Parameter(name="projectCode", description="WORKFLOW_DEFINITION_NAME", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="workFlowCode", description="WORKFLOW_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class))})
    @GetMapping(value={"/query-dependent-tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKFLOW_LINEAGE_ERROR)
    public Result<Map<String, Object>> queryDependentTasks(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="workFlowCode") long workFlowCode, @RequestParam(value="taskCode", required=false) Long taskCode) {
        HashMap<String, List<DependentLineageTask>> result = new HashMap<String, List<DependentLineageTask>>();
        List<DependentLineageTask> dependentLineageTaskList = this.workflowLineageService.queryDependentWorkflowDefinitions(projectCode, workFlowCode, taskCode);
        result.put("data", dependentLineageTaskList);
        return Result.success(result);
    }
}

