/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.vo;

import java.io.File;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.spi.enums.ResourceType;

public class ResourceItemVO {
    private String alias;
    private String userName;
    private String fileName;
    private String fullName;
    private boolean isDirectory;
    private ResourceType type;
    private long size;
    private Date createTime;
    private Date updateTime;

    public ResourceItemVO(StorageEntity storageEntity) {
        this.isDirectory = storageEntity.isDirectory();
        this.alias = storageEntity.getFileName();
        this.fileName = storageEntity.getFileName();
        this.fullName = storageEntity.getFullName();
        this.type = storageEntity.getType();
        this.size = storageEntity.getSize();
        this.createTime = storageEntity.getCreateTime();
        this.updateTime = storageEntity.getUpdateTime();
        if (this.isDirectory) {
            this.alias = StringUtils.removeEndIgnoreCase((String)this.alias, (String)File.separator);
            this.fileName = StringUtils.removeEndIgnoreCase((String)this.fileName, (String)File.separator);
            this.fullName = StringUtils.removeEndIgnoreCase((String)this.fullName, (String)File.separator);
        }
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Generated
    public ResourceType getType() {
        return this.type;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Generated
    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    @Generated
    public void setType(ResourceType type) {
        this.type = type;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceItemVO)) {
            return false;
        }
        ResourceItemVO other = (ResourceItemVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDirectory() != other.isDirectory()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        ResourceType this$type = this.getType();
        ResourceType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceItemVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDirectory() ? 79 : 97);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        ResourceType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResourceItemVO(alias=" + this.getAlias() + ", userName=" + this.getUserName() + ", fileName=" + this.getFileName() + ", fullName=" + this.getFullName() + ", isDirectory=" + this.isDirectory() + ", type=" + this.getType() + ", size=" + this.getSize() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    @Generated
    public ResourceItemVO() {
    }

    @Generated
    public ResourceItemVO(String alias, String userName, String fileName, String fullName, boolean isDirectory, ResourceType type, long size, Date createTime, Date updateTime) {
        this.alias = alias;
        this.userName = userName;
        this.fileName = fileName;
        this.fullName = fullName;
        this.isDirectory = isDirectory;
        this.type = type;
        this.size = size;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }
}

