/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.RegexUtils;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantServiceImpl
extends BaseServiceImpl
implements TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private WorkflowInstanceMapper workflowInstanceMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private QueueService queueService;
    @Autowired(required=false)
    private StorageOperator storageOperator;

    private void createTenantValid(Tenant tenant) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)tenant.getTenantCode())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, tenant.getTenantCode());
        }
        if (StringUtils.length((CharSequence)tenant.getTenantCode()) > 30) {
            throw new ServiceException(Status.TENANT_FULL_NAME_TOO_LONG_ERROR);
        }
        if (!RegexUtils.isValidLinuxUserName(tenant.getTenantCode())) {
            throw new ServiceException(Status.CHECK_OS_TENANT_CODE_ERROR);
        }
        if (this.checkTenantExists(tenant.getTenantCode())) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, tenant.getTenantCode());
        }
    }

    private void updateTenantValid(Tenant existsTenant, Tenant updateTenant) throws ServiceException {
        if (Objects.isNull(existsTenant)) {
            log.error("Tenant does not exist.");
            throw new ServiceException(Status.TENANT_NOT_EXIST);
        }
        if (StringUtils.isEmpty((CharSequence)updateTenant.getTenantCode())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, updateTenant.getTenantCode());
        }
        if (StringUtils.length((CharSequence)updateTenant.getTenantCode()) > 30) {
            throw new ServiceException(Status.TENANT_FULL_NAME_TOO_LONG_ERROR);
        }
        if (!RegexUtils.isValidLinuxUserName(updateTenant.getTenantCode())) {
            throw new ServiceException(Status.CHECK_OS_TENANT_CODE_ERROR);
        }
        if (!Objects.equals(existsTenant.getTenantCode(), updateTenant.getTenantCode()) && this.checkTenantExists(updateTenant.getTenantCode())) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, updateTenant.getTenantCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tenant createTenant(User loginUser, String tenantCode, int queueId, String desc) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.TENANT, "security:tenant:create")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (this.checkDescriptionLength(desc)) {
            throw new ServiceException(Status.DESCRIPTION_TOO_LONG_ERROR);
        }
        Tenant tenant = new Tenant(tenantCode, desc, queueId);
        this.createTenantValid(tenant);
        this.tenantMapper.insert((Object)tenant);
        return tenant;
    }

    @Override
    public PageInfo<Tenant> queryTenantList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.TENANT, loginUser.getId(), log);
        if (CollectionUtils.isEmpty(ids)) {
            return new PageInfo<Tenant>(pageNo, pageSize);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage tenantPage = this.tenantMapper.queryTenantPaging((IPage)page, new ArrayList(ids), searchVal);
        return PageInfo.of(tenantPage);
    }

    @Override
    public void updateTenant(User loginUser, int id, String tenantCode, int queueId, String desc) throws Exception {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.TENANT, "security:tenant:update")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (this.checkDescriptionLength(desc)) {
            throw new ServiceException(Status.DESCRIPTION_TOO_LONG_ERROR);
        }
        Tenant updateTenant = new Tenant(id, tenantCode, desc, queueId);
        Tenant existsTenant = this.tenantMapper.queryById(id);
        this.updateTenantValid(existsTenant, updateTenant);
        updateTenant.setCreateTime(existsTenant.getCreateTime());
        int update = this.tenantMapper.updateById(updateTenant);
        if (update <= 0) {
            throw new ServiceException(Status.UPDATE_TENANT_ERROR);
        }
    }

    @Override
    @Transactional
    public void deleteTenantById(User loginUser, int id) throws Exception {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.TENANT, "security:tenant:delete")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Tenant tenant = this.tenantMapper.queryById(id);
        if (Objects.isNull(tenant)) {
            throw new ServiceException(Status.TENANT_NOT_EXIST);
        }
        List<WorkflowInstance> workflowInstances = this.getWorkflowInstancesByTenant(tenant);
        if (CollectionUtils.isNotEmpty(workflowInstances)) {
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL, workflowInstances.size());
        }
        List schedules = this.scheduleMapper.queryScheduleListByTenant(tenant.getTenantCode());
        if (CollectionUtils.isNotEmpty((Collection)schedules)) {
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL_DEFINES, schedules.size());
        }
        List userList = this.userMapper.queryUserListByTenant(tenant.getId().intValue());
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL_USERS, userList.size());
        }
        int delete = this.tenantMapper.deleteById(id);
        if (delete <= 0) {
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_ERROR);
        }
        this.workflowInstanceMapper.updateWorkflowInstanceByTenantCode(tenant.getTenantCode(), "default");
    }

    private List<WorkflowInstance> getWorkflowInstancesByTenant(Tenant tenant) {
        return this.workflowInstanceMapper.queryByTenantCodeAndStatus(tenant.getTenantCode(), WorkflowExecutionStatus.getNotTerminalStatus());
    }

    @Override
    public List<Tenant> queryTenantList(User loginUser) {
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.TENANT, loginUser.getId(), log);
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.tenantMapper.selectBatchIds(ids);
    }

    @Override
    public void verifyTenantCode(String tenantCode) {
        if (this.checkTenantExists(tenantCode)) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, tenantCode);
        }
    }

    private boolean checkTenantExists(String tenantCode) {
        Boolean existTenant = this.tenantMapper.existTenant(tenantCode);
        return Boolean.TRUE.equals(existTenant);
    }

    @Override
    public Map<String, Object> queryByTenantCode(String tenantCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Tenant tenant = this.tenantMapper.queryByTenantCode(tenantCode);
        if (tenant != null) {
            result.put("data", tenant);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Tenant createTenantIfNotExists(String tenantCode, String desc, String queue, String queueName) {
        if (this.checkTenantExists(tenantCode)) {
            return this.tenantMapper.queryByTenantCode(tenantCode);
        }
        Queue queueObj = this.queueService.createQueueIfNotExists(queue, queueName);
        Tenant tenant = new Tenant(tenantCode, desc, queueObj.getId().intValue());
        this.createTenantValid(tenant);
        this.tenantMapper.insert((Object)tenant);
        return tenant;
    }
}

