/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.QueueMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueueServiceImpl
extends BaseServiceImpl
implements QueueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueServiceImpl.class);
    @Autowired
    private QueueMapper queueMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private TenantMapper tenantMapper;

    private void validQueue(Queue queue) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)queue.getQueue())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queue");
        }
        if (StringUtils.isEmpty((CharSequence)queue.getQueueName())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queueName");
        }
        if (this.checkQueueExist(queue.getQueue())) {
            throw new ServiceException(Status.QUEUE_VALUE_EXIST, queue.getQueue());
        }
        if (this.checkQueueNameExist(queue.getQueueName())) {
            throw new ServiceException(Status.QUEUE_NAME_EXIST, queue.getQueueName());
        }
    }

    private void updateQueueValid(Queue existsQueue, Queue updateQueue) throws ServiceException {
        if (Objects.isNull(existsQueue)) {
            throw new ServiceException(Status.QUEUE_NOT_EXIST, updateQueue.getQueue());
        }
        if (Objects.equals(existsQueue, updateQueue)) {
            throw new ServiceException(Status.NEED_NOT_UPDATE_QUEUE);
        }
        if (StringUtils.isEmpty((CharSequence)updateQueue.getQueue())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queue");
        }
        if (StringUtils.isEmpty((CharSequence)updateQueue.getQueueName())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queueName");
        }
        if (!Objects.equals(updateQueue.getQueue(), existsQueue.getQueue()) && this.checkQueueExist(updateQueue.getQueue())) {
            throw new ServiceException(Status.QUEUE_VALUE_EXIST, updateQueue.getQueue());
        }
        if (!Objects.equals(updateQueue.getQueueName(), existsQueue.getQueueName()) && this.checkQueueNameExist(updateQueue.getQueueName())) {
            throw new ServiceException(Status.QUEUE_NAME_EXIST, updateQueue.getQueueName());
        }
    }

    @Override
    public List<Queue> queryList(User loginUser) {
        HashSet<Integer> ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.QUEUE, loginUser.getId(), log);
        if (loginUser.getUserType().equals((Object)UserType.GENERAL_USER)) {
            ids = ids.isEmpty() ? new HashSet<Integer>() : ids;
            ids.add(Constants.DEFAULT_QUEUE_ID);
        }
        return this.queueMapper.selectBatchIds(ids);
    }

    @Override
    public PageInfo<Queue> queryList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        PageInfo<Queue> pageInfo = new PageInfo<Queue>(pageNo, pageSize);
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.QUEUE, loginUser.getId(), log);
        if (ids.isEmpty()) {
            return pageInfo;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage queueList = this.queueMapper.queryQueuePaging((IPage)page, new ArrayList(ids), searchVal);
        Integer count = (int)queueList.getTotal();
        pageInfo.setTotal(count);
        pageInfo.setTotalList(queueList.getRecords());
        return pageInfo;
    }

    @Override
    public Queue createQueue(User loginUser, String queue, String queueName) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.QUEUE, "security:queue:create")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Queue queueObj = new Queue(queueName, queue);
        this.validQueue(queueObj);
        this.queueMapper.insert((Object)queueObj);
        return queueObj;
    }

    @Override
    public Queue updateQueue(User loginUser, int id, String queue, String queueName) {
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.QUEUE, "security:queue:update")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Queue updateQueue = new Queue(id, queueName, queue);
        Queue existsQueue = (Queue)this.queueMapper.selectById((Serializable)Integer.valueOf(id));
        this.updateQueueValid(existsQueue, updateQueue);
        if (this.checkIfQueueIsInUsing(existsQueue.getQueueName(), updateQueue.getQueueName())) {
            Integer relatedUserNums = this.userMapper.updateUserQueue(existsQueue.getQueueName(), updateQueue.getQueueName());
            log.info("Old queue have related {} users, exec update user success.", (Object)relatedUserNums);
        }
        this.queueMapper.updateById((Object)updateQueue);
        return updateQueue;
    }

    @Override
    public void deleteQueueById(User loginUser, int id) throws Exception {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.TENANT, "security:tenant:delete")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Queue queue = (Queue)this.queueMapper.selectById((Serializable)Integer.valueOf(id));
        if (Objects.isNull(queue)) {
            log.error("Queue does not exist");
            throw new ServiceException(Status.QUEUE_NOT_EXIST);
        }
        List tenantList = this.tenantMapper.queryTenantListByQueueId(queue.getId());
        if (CollectionUtils.isNotEmpty((Collection)tenantList)) {
            log.warn("Delete queue failed, because there are {} tenants using it.", (Object)tenantList.size());
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL_TENANTS, tenantList.size());
        }
        List userList = this.userMapper.queryUserListByQueue(queue.getQueueName());
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            log.warn("Delete queue failed, because there are {} users using it.", (Object)userList.size());
            throw new ServiceException(Status.DELETE_QUEUE_BY_ID_FAIL_USERS, userList.size());
        }
        int delete = this.queueMapper.deleteById((Serializable)Integer.valueOf(id));
        if (delete <= 0) {
            throw new ServiceException(Status.DELETE_QUEUE_BY_ID_ERROR);
        }
    }

    @Override
    public void verifyQueue(String queue, String queueName) {
        Queue queueValidator = new Queue(queueName, queue);
        this.validQueue(queueValidator);
    }

    private boolean checkQueueExist(String queue) {
        return this.queueMapper.existQueue(queue, null) == Boolean.TRUE;
    }

    private boolean checkQueueNameExist(String queueName) {
        return this.queueMapper.existQueue(null, queueName) == Boolean.TRUE;
    }

    private boolean checkIfQueueIsInUsing(String oldQueue, String newQueue) {
        return !oldQueue.equals(newQueue) && this.userMapper.existUser(oldQueue) == Boolean.TRUE;
    }

    @Override
    public Queue createQueueIfNotExists(String queue, String queueName) {
        Queue existsQueue = this.queueMapper.queryQueueName(queue, queueName);
        if (!Objects.isNull(existsQueue)) {
            log.info("Queue exists, so return it, queueName:{}.", (Object)queueName);
            return existsQueue;
        }
        Queue queueObj = new Queue(queueName, queue);
        this.validQueue(queueObj);
        this.queueMapper.insert((Object)queueObj);
        log.info("Queue create complete, queueName:{}.", (Object)queueObj.getQueueName());
        return queueObj;
    }
}

