/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.CommandStateCount;
import org.apache.dolphinscheduler.api.dto.DefineUserDto;
import org.apache.dolphinscheduler.api.dto.TaskCountDto;
import org.apache.dolphinscheduler.api.dto.project.StatisticsStateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.DataAnalysisService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.vo.TaskInstanceCountVO;
import org.apache.dolphinscheduler.api.vo.WorkflowDefinitionCountVO;
import org.apache.dolphinscheduler.api.vo.WorkflowInstanceCountVO;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.CommandCount;
import org.apache.dolphinscheduler.dao.entity.ErrorCommand;
import org.apache.dolphinscheduler.dao.entity.ExecuteStatusCount;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataAnalysisServiceImpl
extends BaseServiceImpl
implements DataAnalysisService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataAnalysisServiceImpl.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private WorkflowInstanceMapper workflowInstanceMapper;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;

    @Override
    public TaskInstanceCountVO getTaskInstanceStateCountByProject(User loginUser, Long projectCode, String startDate, String endDate) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:overview:view");
        Date start = startDate == null ? null : this.transformDate(startDate);
        Date end = endDate == null ? null : this.transformDate(endDate);
        List taskInstanceStatusCounts = this.taskInstanceMapper.countTaskInstanceStateByProjectCodes(start, end, (Collection)Lists.newArrayList((Object[])new Long[]{projectCode}));
        return TaskInstanceCountVO.of(taskInstanceStatusCounts);
    }

    @Override
    public TaskInstanceCountVO getAllTaskInstanceStateCount(User loginUser, String startDate, String endDate) {
        List<Long> projectCodes = this.projectService.getAuthorizedProjectCodes(loginUser);
        if (CollectionUtils.isEmpty(projectCodes)) {
            return TaskInstanceCountVO.empty();
        }
        Date start = startDate == null ? null : this.transformDate(startDate);
        Date end = endDate == null ? null : this.transformDate(endDate);
        List taskInstanceStatusCounts = this.taskInstanceMapper.countTaskInstanceStateByProjectCodes(start, end, projectCodes);
        return TaskInstanceCountVO.of(taskInstanceStatusCounts);
    }

    @Override
    public WorkflowInstanceCountVO getWorkflowInstanceStateCountByProject(User loginUser, Long projectCode, String startDate, String endDate) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:overview:view");
        Date start = startDate == null ? null : this.transformDate(startDate);
        Date end = endDate == null ? null : this.transformDate(endDate);
        List workflowInstanceStatusCountDtos = this.workflowInstanceMapper.countWorkflowInstanceStateByProjectCodes(start, end, (Collection)Lists.newArrayList((Object[])new Long[]{projectCode}));
        return WorkflowInstanceCountVO.of(workflowInstanceStatusCountDtos);
    }

    @Override
    public WorkflowInstanceCountVO getAllWorkflowInstanceStateCount(User loginUser, String startDate, String endDate) {
        List<Long> projectCodes = this.projectService.getAuthorizedProjectCodes(loginUser);
        if (CollectionUtils.isEmpty(projectCodes)) {
            return WorkflowInstanceCountVO.empty();
        }
        Date start = startDate == null ? null : this.transformDate(startDate);
        Date end = endDate == null ? null : this.transformDate(endDate);
        List workflowInstanceStatusCountDtos = this.workflowInstanceMapper.countWorkflowInstanceStateByProjectCodes(start, end, projectCodes);
        return WorkflowInstanceCountVO.of(workflowInstanceStatusCountDtos);
    }

    @Override
    public WorkflowDefinitionCountVO getWorkflowDefinitionCountByProject(User loginUser, Long projectCode) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:overview:view");
        List workflowDefinitionCounts = this.workflowDefinitionMapper.countDefinitionByProjectCodes((Collection)Lists.newArrayList((Object[])new Long[]{projectCode}));
        return WorkflowDefinitionCountVO.of(workflowDefinitionCounts);
    }

    @Override
    public WorkflowDefinitionCountVO getAllWorkflowDefinitionCount(User loginUser) {
        List<Long> projectCodes = this.projectService.getAuthorizedProjectCodes(loginUser);
        if (CollectionUtils.isEmpty(projectCodes)) {
            return WorkflowDefinitionCountVO.empty();
        }
        return WorkflowDefinitionCountVO.of(this.workflowDefinitionMapper.countDefinitionByProjectCodes(projectCodes));
    }

    @Override
    public List<CommandStateCount> countCommandState(User loginUser) {
        List<Long> projectCodes = this.projectService.getAuthorizedProjectCodes(loginUser);
        Map<CommandType, Integer> normalCountCommandCounts = this.commandMapper.countCommandState(null, null, projectCodes).stream().collect(Collectors.toMap(CommandCount::getCommandType, CommandCount::getCount));
        Map<CommandType, Integer> errorCommandCounts = this.errorCommandMapper.countCommandState(null, null, projectCodes).stream().collect(Collectors.toMap(CommandCount::getCommandType, CommandCount::getCount));
        List<CommandStateCount> list = Arrays.stream(CommandType.values()).map(commandType -> new CommandStateCount(errorCommandCounts.getOrDefault(commandType, 0), normalCountCommandCounts.getOrDefault(commandType, 0), (CommandType)commandType)).collect(Collectors.toList());
        return list;
    }

    @Override
    public Map<String, Integer> countQueueState(User loginUser) {
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("taskQueue", 0);
        dataMap.put("taskKill", 0);
        return dataMap;
    }

    @Override
    public TaskCountDto countWorkflowStates(User loginUser, StatisticsStateRequest statisticsStateRequest) {
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (projectIds.isEmpty()) {
            return new TaskCountDto(Collections.emptyList());
        }
        String projectName = statisticsStateRequest.getProjectName();
        String workflowName = statisticsStateRequest.getWorkflowName();
        Long projectCode = statisticsStateRequest.getProjectCode();
        Long workflowCode = statisticsStateRequest.getWorkflowCode();
        Integer model = Constants.QUERY_ALL_ON_SYSTEM;
        if (!StringUtils.isBlank((CharSequence)projectName) || null != projectCode) {
            model = Constants.QUERY_ALL_ON_PROJECT;
        }
        if (!StringUtils.isBlank((CharSequence)workflowName) || null != workflowCode) {
            model = Constants.QUERY_ALL_ON_WORKFLOW;
        }
        try {
            if (null == workflowCode || null == projectCode) {
                projectCode = this.projectMapper.queryByName(projectName).getCode();
                workflowCode = this.workflowDefinitionMapper.queryByDefineName(projectCode.longValue(), workflowName).getCode();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        Date date = new Date();
        Date startTime = statisticsStateRequest.getStartTime() == null ? DateUtils.addMonths((Date)date, (int)-1) : statisticsStateRequest.getStartTime();
        Date endTime = statisticsStateRequest.getEndTime() == null ? date : statisticsStateRequest.getEndTime();
        List executeStatusCounts = this.workflowInstanceMapper.countInstanceStateV2(startTime, endTime, projectCode, workflowCode, model, projectIds);
        return new TaskCountDto(executeStatusCounts);
    }

    @Override
    public TaskCountDto countOneWorkflowStates(User loginUser, Long workflowCode) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowCode.longValue());
        if (workflowDefinition == null) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, workflowCode);
        }
        this.projectService.checkHasProjectWritePermissionThrowException(loginUser, workflowDefinition.getProjectCode());
        List executeStatusCounts = this.workflowInstanceMapper.countInstanceStateV2(null, null, null, workflowCode, Constants.QUERY_ALL_ON_WORKFLOW, null);
        return new TaskCountDto(executeStatusCounts);
    }

    @Override
    public TaskCountDto countTaskStates(User loginUser, StatisticsStateRequest statisticsStateRequest) {
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (projectIds.isEmpty()) {
            return new TaskCountDto(Collections.emptyList());
        }
        String projectName = statisticsStateRequest.getProjectName();
        String workflowName = statisticsStateRequest.getWorkflowName();
        String taskName = statisticsStateRequest.getTaskName();
        Long projectCode = statisticsStateRequest.getProjectCode();
        Long workflowCode = statisticsStateRequest.getWorkflowCode();
        Long taskCode = statisticsStateRequest.getTaskCode();
        Integer model = Constants.QUERY_ALL_ON_SYSTEM;
        if (!StringUtils.isBlank((CharSequence)projectName) || null != projectCode) {
            model = Constants.QUERY_ALL_ON_PROJECT;
        }
        if (!StringUtils.isBlank((CharSequence)workflowName) || null != workflowCode) {
            model = Constants.QUERY_ALL_ON_WORKFLOW;
        }
        if (!StringUtils.isBlank((CharSequence)taskName) || null != taskCode) {
            model = Constants.QUERY_ALL_ON_TASK;
        }
        try {
            if (null == taskCode || null == workflowCode || null == projectCode) {
                projectCode = this.projectMapper.queryByName(projectName).getCode();
                workflowCode = this.workflowDefinitionMapper.queryByDefineName(projectCode.longValue(), workflowName).getCode();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        Date date = new Date();
        Date startTime = statisticsStateRequest.getStartTime() == null ? DateUtils.addMonths((Date)date, (int)-1) : statisticsStateRequest.getStartTime();
        Date endTime = statisticsStateRequest.getEndTime() == null ? date : statisticsStateRequest.getEndTime();
        Optional<List<ExecuteStatusCount>> startTimeStates = Optional.ofNullable(this.taskInstanceMapper.countTaskInstanceStateByProjectIdsV2(startTime, endTime, projectIds));
        List<TaskExecutionStatus> needRecountState = this.setOptional(startTimeStates);
        if (needRecountState.size() == 0) {
            return new TaskCountDto(startTimeStates.get());
        }
        List recounts = this.taskInstanceMapper.countTaskInstanceStateByProjectCodesAndStatesBySubmitTimeV2(startTime, endTime, projectCode, workflowCode, taskCode, model, projectIds, needRecountState);
        startTimeStates.orElseGet(ArrayList::new).addAll(recounts);
        List executeStatusCounts = startTimeStates.orElse(null);
        return new TaskCountDto(executeStatusCounts);
    }

    @Override
    public TaskCountDto countOneTaskStates(User loginUser, Long taskCode) {
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode.longValue());
        long projectCode = taskDefinition.getProjectCode();
        Project project = this.projectMapper.queryByCode(projectCode);
        this.projectService.checkHasProjectWritePermissionThrowException(loginUser, project);
        Set<Integer> projectId = Collections.singleton(project.getId());
        Optional<List<ExecuteStatusCount>> startTimeStates = Optional.ofNullable(this.taskInstanceMapper.countTaskInstanceStateByProjectIdsV2(null, null, projectId));
        List<TaskExecutionStatus> needRecountState = this.setOptional(startTimeStates);
        if (needRecountState.size() == 0) {
            return new TaskCountDto(startTimeStates.get());
        }
        List recounts = this.taskInstanceMapper.countTaskInstanceStateByProjectCodesAndStatesBySubmitTimeV2(null, null, Long.valueOf(projectCode), null, taskCode, Constants.QUERY_ALL_ON_TASK, projectId, needRecountState);
        startTimeStates.orElseGet(ArrayList::new).addAll(recounts);
        List executeStatusCounts = startTimeStates.orElse(null);
        return new TaskCountDto(executeStatusCounts);
    }

    @Override
    public PageInfo<Command> listPendingCommands(User loginUser, Long projectCode, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            IPage commandIPage = this.commandMapper.queryCommandPage(page);
            return PageInfo.of(commandIPage);
        }
        List<Long> workflowDefinitionCodes = this.getAuthDefinitionCodes(loginUser, projectCode);
        if (workflowDefinitionCodes.isEmpty()) {
            return PageInfo.of(pageNo, pageSize);
        }
        IPage commandIPage = this.commandMapper.queryCommandPageByIds(page, new ArrayList<Long>(workflowDefinitionCodes));
        return PageInfo.of(commandIPage);
    }

    @Override
    public PageInfo<ErrorCommand> listErrorCommand(User loginUser, Long projectCode, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            IPage commandIPage = this.errorCommandMapper.queryErrorCommandPage(page);
            return PageInfo.of(commandIPage);
        }
        List<Long> workflowDefinitionCodes = this.getAuthDefinitionCodes(loginUser, projectCode);
        if (workflowDefinitionCodes.isEmpty()) {
            return PageInfo.of(pageNo, pageSize);
        }
        IPage commandIPage = this.errorCommandMapper.queryErrorCommandPageByIds(page, new ArrayList<Long>(workflowDefinitionCodes));
        return PageInfo.of(commandIPage);
    }

    private List<Long> getAuthDefinitionCodes(User loginUser, Long projectCode) {
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (CollectionUtils.isEmpty(projectIds)) {
            return Collections.emptyList();
        }
        List<Object> projectCodes = this.projectMapper.selectBatchIds(projectIds).stream().map(Project::getCode).collect(Collectors.toList());
        if (projectCode != null) {
            if (!projectCodes.contains(projectCode)) {
                return Collections.emptyList();
            }
            projectCodes = Collections.singletonList(projectCode);
        }
        return this.workflowDefinitionMapper.queryDefinitionCodeListByProjectCodes(projectCodes);
    }

    @Override
    public DefineUserDto countDefinitionByUserV2(User loginUser, Integer userId, Integer releaseState) {
        Set projectIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.PROJECTS, loginUser.getId(), log);
        if (CollectionUtils.isEmpty(projectIds)) {
            return new DefineUserDto(Collections.emptyList());
        }
        List projectCodes = this.projectMapper.selectBatchIds(projectIds).stream().map(Project::getCode).collect(Collectors.toList());
        List workflowDefinitionCountDtos = this.workflowDefinitionMapper.countDefinitionByProjectCodesV2(projectCodes, userId, releaseState);
        return new DefineUserDto(workflowDefinitionCountDtos);
    }

    private List<TaskExecutionStatus> setOptional(Optional<List<ExecuteStatusCount>> startTimeStates) {
        List<TaskExecutionStatus> allState = Arrays.stream(TaskExecutionStatus.values()).collect(Collectors.toList());
        if (startTimeStates.isPresent() && startTimeStates.get().size() != 0) {
            List instanceState = startTimeStates.get().stream().map(ExecuteStatusCount::getState).collect(Collectors.toList());
            return allState.stream().filter(ele -> !instanceState.contains(ele)).collect(Collectors.toList());
        }
        return allState;
    }
}

