/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.List;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotNode
extends BranchNode {
    public NotNode(List<ExprNode> children) {
        super(AssertionType.NOT);
        if (this.children.size() > 1) {
            throw new IllegalStateException("Cannot add more than one element to a negation node.");
        }
    }

    public NotNode() {
        this((List<ExprNode>)null);
    }

    @Override
    public void addNode(ExprNode node) {
        if (this.children.size() >= 1) {
            throw new IllegalStateException("Cannot add more than one element to a negation node.");
        }
        this.children.add(node);
    }

    @Override
    public void addNodeToHead(ExprNode node) {
        if (this.children.size() >= 1) {
            throw new IllegalStateException("Cannot add more than one element to a negation node.");
        }
        this.children.add(node);
    }

    @Override
    public void setChildren(List<ExprNode> list) {
        if (list != null && list.size() > 1) {
            throw new IllegalStateException("Cannot add more than one element to a negation node.");
        }
        this.children = list;
    }

    public AssertionType getOperator() {
        return AssertionType.NOT;
    }

    public boolean isDisjunction() {
        return false;
    }

    public boolean isConjunction() {
        return false;
    }

    public boolean isNegation() {
        return true;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) throws UnsupportedOperationException {
        buf.append("not: {");
        boolean isFirst = true;
        for (ExprNode node : this.children) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            node.printRefinementToBuffer(buf);
        }
        buf.append('}');
        return buf;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(!");
        buf.append(super.toString());
        buf.append(this.getFirstChild());
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + AssertionType.NOT.hashCode();
        hash = hash * 17 + (this.annotations == null ? 0 : ((Object)this.annotations).hashCode());
        return hash;
    }
}

