/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.Control;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapResult;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequest;
import org.apache.directory.shared.ldap.codec.add.AddRequest;
import org.apache.directory.shared.ldap.codec.add.AddResponse;
import org.apache.directory.shared.ldap.codec.bind.BindRequest;
import org.apache.directory.shared.ldap.codec.bind.BindResponse;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.apache.directory.shared.ldap.codec.bind.SaslCredentials;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.compare.CompareRequest;
import org.apache.directory.shared.ldap.codec.compare.CompareResponse;
import org.apache.directory.shared.ldap.codec.controls.CascadeControlCodec;
import org.apache.directory.shared.ldap.codec.del.DelRequest;
import org.apache.directory.shared.ldap.codec.del.DelResponse;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequest;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponse;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequest;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponse;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequest;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponse;
import org.apache.directory.shared.ldap.codec.search.AndFilter;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.NotFilter;
import org.apache.directory.shared.ldap.codec.search.OrFilter;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.codec.search.SearchResultDone;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntry;
import org.apache.directory.shared.ldap.codec.search.SearchResultReference;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.codec.search.controls.PSearchControlCodec;
import org.apache.directory.shared.ldap.codec.search.controls.SubEntryControlCodec;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.message.AbandonRequestImpl;
import org.apache.directory.shared.ldap.message.AbstractMutableControlImpl;
import org.apache.directory.shared.ldap.message.AddRequestImpl;
import org.apache.directory.shared.ldap.message.AddResponseImpl;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.BindRequestImpl;
import org.apache.directory.shared.ldap.message.BindResponseImpl;
import org.apache.directory.shared.ldap.message.CascadeControl;
import org.apache.directory.shared.ldap.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.message.DeleteResponseImpl;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.LdapResultImpl;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ModifyDnRequestImpl;
import org.apache.directory.shared.ldap.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.message.PersistentSearchControl;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.message.SearchResponseDoneImpl;
import org.apache.directory.shared.ldap.message.SearchResponseEntryImpl;
import org.apache.directory.shared.ldap.message.SearchResponseReferenceImpl;
import org.apache.directory.shared.ldap.message.SubentriesControl;
import org.apache.directory.shared.ldap.message.UnbindRequestImpl;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownRequest;
import org.apache.directory.shared.ldap.message.spi.Provider;
import org.apache.directory.shared.ldap.message.spi.TransformerSpi;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwixTransformer
implements TransformerSpi {
    private static Logger log = LoggerFactory.getLogger(TwixTransformer.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private final Provider provider;

    public TwixTransformer(Provider provider) {
        this.provider = provider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    private Message transformAbandonRequest(LdapMessage twixMessage, int messageId) {
        AbandonRequestImpl snickersMessage = new AbandonRequestImpl(messageId);
        AbandonRequest abandonRequest = twixMessage.getAbandonRequest();
        snickersMessage.setAbandoned(abandonRequest.getAbandonedMessageId());
        return snickersMessage;
    }

    private Message transformAddRequest(LdapMessage twixMessage, int messageId) {
        AddRequestImpl snickersMessage = new AddRequestImpl(messageId);
        AddRequest addRequest = twixMessage.getAddRequest();
        snickersMessage.setEntry(addRequest.getEntry());
        snickersMessage.setAttributes(addRequest.getAttributes());
        return snickersMessage;
    }

    private Message transformBindRequest(LdapMessage twixMessage, int messageId) {
        BindRequestImpl snickersMessage = new BindRequestImpl(messageId);
        BindRequest bindRequest = twixMessage.getBindRequest();
        snickersMessage.setVersion3(bindRequest.isLdapV3());
        snickersMessage.setName(bindRequest.getName());
        LdapAuthentication authentication = bindRequest.getAuthentication();
        if (authentication instanceof SimpleAuthentication) {
            snickersMessage.setSimple(true);
            snickersMessage.setCredentials(((SimpleAuthentication)authentication).getSimple());
        } else {
            snickersMessage.setSimple(false);
            snickersMessage.setCredentials(((SaslCredentials)authentication).getCredentials());
            snickersMessage.setSaslMechanism(((SaslCredentials)authentication).getMechanism());
        }
        return snickersMessage;
    }

    private Message transformCompareRequest(LdapMessage twixMessage, int messageId) {
        CompareRequestImpl snickersMessage = new CompareRequestImpl(messageId);
        CompareRequest compareRequest = twixMessage.getCompareRequest();
        snickersMessage.setName(compareRequest.getEntry());
        snickersMessage.setAttributeId(compareRequest.getAttributeDesc());
        if (compareRequest.getAssertionValue() instanceof String) {
            snickersMessage.setAssertionValue((String)compareRequest.getAssertionValue());
        } else {
            snickersMessage.setAssertionValue((byte[])compareRequest.getAssertionValue());
        }
        return snickersMessage;
    }

    private Message transformDelRequest(LdapMessage twixMessage, int messageId) {
        DeleteRequestImpl snickersMessage = new DeleteRequestImpl(messageId);
        DelRequest delRequest = twixMessage.getDelRequest();
        snickersMessage.setName(delRequest.getEntry());
        return snickersMessage;
    }

    private Message transformExtendedRequest(LdapMessage twixMessage, int messageId) {
        ExtendedRequest extendedRequest = twixMessage.getExtendedRequest();
        ExtendedRequestImpl snickersMessage = extendedRequest.getRequestName().equals("1.3.6.1.4.1.18060.0.1.3") ? new GracefulShutdownRequest(messageId) : new ExtendedRequestImpl(messageId);
        snickersMessage.setOid(extendedRequest.getRequestName());
        snickersMessage.setPayload(extendedRequest.getRequestValue());
        return snickersMessage;
    }

    private Message transformModifyDNRequest(LdapMessage twixMessage, int messageId) {
        ModifyDnRequestImpl snickersMessage = new ModifyDnRequestImpl(messageId);
        ModifyDNRequest modifyDNRequest = twixMessage.getModifyDNRequest();
        snickersMessage.setName(modifyDNRequest.getEntry());
        snickersMessage.setNewRdn(modifyDNRequest.getNewRDN());
        snickersMessage.setDeleteOldRdn(modifyDNRequest.isDeleteOldRDN());
        snickersMessage.setNewSuperior(modifyDNRequest.getNewSuperior());
        return snickersMessage;
    }

    private Message transformModifyRequest(LdapMessage twixMessage, int messageId) {
        ModifyRequestImpl snickersMessage = new ModifyRequestImpl(messageId);
        ModifyRequest modifyRequest = twixMessage.getModifyRequest();
        snickersMessage.setName(modifyRequest.getObject());
        if (modifyRequest.getModifications() != null) {
            Iterator<ModificationItemImpl> modifications = modifyRequest.getModifications().iterator();
            while (modifications.hasNext()) {
                snickersMessage.addModification(modifications.next());
            }
        }
        return snickersMessage;
    }

    private ExprNode transformFilter(Filter twixFilter) {
        if (twixFilter != null) {
            if (twixFilter instanceof ConnectorFilter) {
                BranchNode branch = null;
                if (twixFilter instanceof AndFilter) {
                    branch = new AndNode();
                } else if (twixFilter instanceof OrFilter) {
                    branch = new OrNode();
                } else if (twixFilter instanceof NotFilter) {
                    branch = new NotNode();
                }
                List<Filter> filtersSet = ((ConnectorFilter)twixFilter).getFilterSet();
                if (filtersSet != null) {
                    Iterator<Filter> filters = filtersSet.iterator();
                    while (filters.hasNext()) {
                        branch.addNode(this.transformFilter(filters.next()));
                    }
                }
                return branch;
            }
            LeafNode branch = null;
            if (twixFilter instanceof PresentFilter) {
                branch = new PresenceNode(((PresentFilter)twixFilter).getAttributeDescription());
            } else if (twixFilter instanceof AttributeValueAssertionFilter) {
                AttributeValueAssertion ava = ((AttributeValueAssertionFilter)twixFilter).getAssertion();
                switch (((AttributeValueAssertionFilter)twixFilter).getFilterType()) {
                    case 0: {
                        if (ava.getAssertionValue() instanceof String) {
                            branch = new EqualityNode(ava.getAttributeDesc(), (String)ava.getAssertionValue());
                            break;
                        }
                        branch = new EqualityNode(ava.getAttributeDesc(), (byte[])ava.getAssertionValue());
                        break;
                    }
                    case 1: {
                        if (ava.getAssertionValue() instanceof String) {
                            branch = new GreaterEqNode(ava.getAttributeDesc(), (String)ava.getAssertionValue());
                            break;
                        }
                        branch = new GreaterEqNode(ava.getAttributeDesc(), (byte[])ava.getAssertionValue());
                        break;
                    }
                    case 2: {
                        if (ava.getAssertionValue() instanceof String) {
                            branch = new LessEqNode(ava.getAttributeDesc(), (String)ava.getAssertionValue());
                            break;
                        }
                        branch = new LessEqNode(ava.getAttributeDesc(), (byte[])ava.getAssertionValue());
                        break;
                    }
                    case 3: {
                        branch = ava.getAssertionValue() instanceof String ? new ApproximateNode(ava.getAttributeDesc(), (String)ava.getAssertionValue()) : new ApproximateNode(ava.getAttributeDesc(), (byte[])ava.getAssertionValue());
                    }
                }
            } else if (twixFilter instanceof SubstringFilter) {
                SubstringFilter filter = (SubstringFilter)twixFilter;
                String initialString = null;
                String finalString = null;
                ArrayList<String> anyString = null;
                if (filter.getInitialSubstrings() != null) {
                    initialString = filter.getInitialSubstrings();
                }
                if (filter.getFinalSubstrings() != null) {
                    finalString = filter.getFinalSubstrings();
                }
                if (filter.getAnySubstrings() != null) {
                    anyString = new ArrayList<String>();
                    for (String any : filter.getAnySubstrings()) {
                        anyString.add(any);
                    }
                }
                branch = new SubstringNode(anyString, filter.getType(), initialString, finalString);
            } else if (twixFilter instanceof ExtensibleMatchFilter) {
                ExtensibleMatchFilter filter = (ExtensibleMatchFilter)twixFilter;
                String attribute = null;
                String matchingRule = null;
                if (filter.getType() != null) {
                    attribute = filter.getType();
                }
                Object value = filter.getMatchValue();
                if (filter.getMatchingRule() != null) {
                    matchingRule = filter.getMatchingRule();
                }
                branch = value instanceof String ? new ExtensibleNode(attribute, (String)value, matchingRule, filter.isDnAttributes()) : (value != null ? new ExtensibleNode(attribute, (byte[])value, matchingRule, filter.isDnAttributes()) : new ExtensibleNode(attribute, (byte[])null, matchingRule, filter.isDnAttributes()));
            }
            return branch;
        }
        return null;
    }

    private Message transformSearchRequest(LdapMessage twixMessage, int messageId) {
        NamingEnumeration<? extends Attribute> attributes;
        SearchRequestImpl snickersMessage = new SearchRequestImpl(messageId);
        SearchRequest searchRequest = twixMessage.getSearchRequest();
        snickersMessage.setBase(searchRequest.getBaseObject());
        snickersMessage.setScope(searchRequest.getScope());
        switch (searchRequest.getDerefAliases()) {
            case 3: {
                snickersMessage.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
                break;
            }
            case 2: {
                snickersMessage.setDerefAliases(AliasDerefMode.DEREF_FINDING_BASE_OBJ);
                break;
            }
            case 1: {
                snickersMessage.setDerefAliases(AliasDerefMode.DEREF_IN_SEARCHING);
                break;
            }
            case 0: {
                snickersMessage.setDerefAliases(AliasDerefMode.NEVER_DEREF_ALIASES);
            }
        }
        snickersMessage.setSizeLimit(searchRequest.getSizeLimit());
        snickersMessage.setTimeLimit(searchRequest.getTimeLimit());
        snickersMessage.setTypesOnly(searchRequest.isTypesOnly());
        Filter twixFilter = searchRequest.getFilter();
        snickersMessage.setFilter(this.transformFilter(twixFilter));
        if (searchRequest.getAttributes() != null && (attributes = searchRequest.getAttributes().getAll()) != null) {
            while (attributes.hasMoreElements()) {
                AttributeImpl attribute = (AttributeImpl)attributes.nextElement();
                if (attribute == null) continue;
                snickersMessage.addAttribute(attribute.getID());
            }
        }
        return snickersMessage;
    }

    private Message transformUnBindRequest(LdapMessage twixMessage, int messageId) {
        return new UnbindRequestImpl(messageId);
    }

    public Message transform(Object obj) {
        LdapMessage twixMessage = (LdapMessage)((Object)obj);
        int messageId = twixMessage.getMessageId();
        if (IS_DEBUG) {
            log.debug("Transforming LdapMessage <" + messageId + ", " + twixMessage.getMessageTypeName() + "> from Twix to Snickers.");
        }
        Message snickersMessage = null;
        int messageType = twixMessage.getMessageType();
        switch (messageType) {
            case 3: {
                snickersMessage = this.transformBindRequest(twixMessage, messageId);
                break;
            }
            case 19: {
                snickersMessage = this.transformUnBindRequest(twixMessage, messageId);
                break;
            }
            case 15: {
                snickersMessage = this.transformSearchRequest(twixMessage, messageId);
                break;
            }
            case 13: {
                snickersMessage = this.transformModifyRequest(twixMessage, messageId);
                break;
            }
            case 1: {
                snickersMessage = this.transformAddRequest(twixMessage, messageId);
                break;
            }
            case 7: {
                snickersMessage = this.transformDelRequest(twixMessage, messageId);
                break;
            }
            case 11: {
                snickersMessage = this.transformModifyDNRequest(twixMessage, messageId);
                break;
            }
            case 5: {
                snickersMessage = this.transformCompareRequest(twixMessage, messageId);
                break;
            }
            case 0: {
                snickersMessage = this.transformAbandonRequest(twixMessage, messageId);
                break;
            }
            case 9: {
                snickersMessage = this.transformExtendedRequest(twixMessage, messageId);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            default: {
                throw new IllegalStateException("shouldn't happen - if it does then we have issues");
            }
        }
        List<Control> twixControls = twixMessage.getControls();
        if (twixControls != null) {
            Iterator<Control> controls = twixControls.iterator();
            while (controls.hasNext()) {
                AbstractMutableControlImpl neutralControl = null;
                final Control twixControl = controls.next();
                if (twixControl.getControlValue() instanceof CascadeControlCodec) {
                    neutralControl = new CascadeControl();
                    neutralControl.setCritical(twixControl.getCriticality());
                } else if (twixControl.getControlValue() instanceof PSearchControlCodec) {
                    PersistentSearchControl neutralPsearch = new PersistentSearchControl();
                    neutralControl = neutralPsearch;
                    PSearchControlCodec twixPsearch = (PSearchControlCodec)((Object)twixControl.getControlValue());
                    neutralPsearch.setChangeTypes(twixPsearch.getChangeTypes());
                    neutralPsearch.setChangesOnly(twixPsearch.isChangesOnly());
                    neutralPsearch.setReturnECs(twixPsearch.isReturnECs());
                    neutralPsearch.setCritical(twixControl.getCriticality());
                } else if (twixControl.getControlValue() instanceof SubEntryControlCodec) {
                    SubentriesControl neutralSubentriesControl = new SubentriesControl();
                    SubEntryControlCodec twixSubentriesControl = (SubEntryControlCodec)((Object)twixControl.getControlValue());
                    neutralControl = neutralSubentriesControl;
                    neutralSubentriesControl.setVisibility(twixSubentriesControl.isVisible());
                    neutralSubentriesControl.setCritical(twixControl.getCriticality());
                } else if (twixControl.getControlValue() instanceof byte[]) {
                    neutralControl = new AbstractMutableControlImpl(){
                        public static final long serialVersionUID = 1L;

                        public byte[] getEncodedValue() {
                            return (byte[])twixControl.getControlValue();
                        }
                    };
                    neutralControl.setCritical(twixControl.getCriticality());
                    neutralControl.setID(twixControl.getControlType());
                } else if (twixControl.getControlValue() == null) {
                    neutralControl = new AbstractMutableControlImpl(){
                        public static final long serialVersionUID = 1L;

                        public byte[] getEncodedValue() {
                            return (byte[])twixControl.getControlValue();
                        }
                    };
                    neutralControl.setCritical(twixControl.getCriticality());
                    neutralControl.setID(twixControl.getControlType());
                }
                snickersMessage.add(neutralControl);
            }
        }
        return snickersMessage;
    }

    private LdapResult transformLdapResult(LdapResultImpl snickersLdapResult) {
        LdapResult twixLdapResult = new LdapResult();
        twixLdapResult.setResultCode(snickersLdapResult.getResultCode());
        String errorMessage = snickersLdapResult.getErrorMessage();
        twixLdapResult.setErrorMessage(StringTools.isEmpty(errorMessage) ? "" : errorMessage);
        twixLdapResult.setMatchedDN(snickersLdapResult.getMatchedDn());
        ReferralImpl snisckersReferrals = (ReferralImpl)snickersLdapResult.getReferral();
        if (snisckersReferrals != null) {
            Iterator<String> referrals = snisckersReferrals.getLdapUrls().iterator();
            twixLdapResult.initReferrals();
            while (referrals.hasNext()) {
                String referral = referrals.next();
                try {
                    LdapURL ldapUrl = new LdapURL(referral.getBytes());
                    twixLdapResult.addReferral(ldapUrl);
                }
                catch (LdapURLEncodingException lude) {
                    log.warn("The referral " + referral + " is invalid : " + lude.getMessage());
                    twixLdapResult.addReferral(LdapURL.EMPTY_URL);
                }
            }
        }
        return twixLdapResult;
    }

    private void transformAddResponse(LdapMessage twixMessage, Message snickersMessage) {
        AddResponseImpl snickersAddResponse = (AddResponseImpl)snickersMessage;
        AddResponse addResponse = new AddResponse();
        addResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersAddResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)addResponse);
    }

    private void transformBindResponse(LdapMessage twixMessage, Message snickersMessage) {
        BindResponseImpl snickersBindResponse = (BindResponseImpl)snickersMessage;
        BindResponse bindResponse = new BindResponse();
        byte[] serverSaslCreds = snickersBindResponse.getServerSaslCreds();
        if (serverSaslCreds != null) {
            bindResponse.setServerSaslCreds(serverSaslCreds);
        }
        bindResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersBindResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)bindResponse);
    }

    private void transformCompareResponse(LdapMessage twixMessage, Message snickersMessage) {
        CompareResponseImpl snickersCompareResponse = (CompareResponseImpl)snickersMessage;
        CompareResponse compareResponse = new CompareResponse();
        compareResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersCompareResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)compareResponse);
    }

    private void transformDelResponse(LdapMessage twixMessage, Message snickersMessage) {
        DeleteResponseImpl snickersDelResponse = (DeleteResponseImpl)snickersMessage;
        DelResponse delResponse = new DelResponse();
        delResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersDelResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)delResponse);
    }

    private void transformExtendedResponse(LdapMessage twixMessage, Message snickersMessage) {
        ExtendedResponseImpl snickersExtendedResponse = (ExtendedResponseImpl)snickersMessage;
        ExtendedResponse extendedResponse = new ExtendedResponse();
        try {
            extendedResponse.setResponseName(new OID(snickersExtendedResponse.getResponseName()));
        }
        catch (DecoderException de) {
            log.warn("The OID " + snickersExtendedResponse.getResponseName() + " is invalid : " + de.getMessage());
            extendedResponse.setResponseName(null);
        }
        extendedResponse.setResponse(snickersExtendedResponse.getResponse());
        extendedResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersExtendedResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)extendedResponse);
    }

    private void transformModifyResponse(LdapMessage twixMessage, Message snickersMessage) {
        ModifyResponseImpl snickersModifyResponse = (ModifyResponseImpl)snickersMessage;
        ModifyResponse modifyResponse = new ModifyResponse();
        modifyResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersModifyResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)modifyResponse);
    }

    private void transformModifyDNResponse(LdapMessage twixMessage, Message snickersMessage) {
        ModifyDnResponseImpl snickersModifyDNResponse = (ModifyDnResponseImpl)snickersMessage;
        ModifyDNResponse modifyDNResponse = new ModifyDNResponse();
        modifyDNResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersModifyDNResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)modifyDNResponse);
    }

    private void transformSearchResultDone(LdapMessage twixMessage, Message snickersMessage) {
        SearchResponseDoneImpl snickersSearchResponseDone = (SearchResponseDoneImpl)snickersMessage;
        SearchResultDone searchResultDone = new SearchResultDone();
        searchResultDone.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersSearchResponseDone.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)searchResultDone);
    }

    private void transformSearchResultEntry(LdapMessage twixMessage, Message snickersMessage) {
        SearchResponseEntryImpl snickersSearchResultResponse = (SearchResponseEntryImpl)snickersMessage;
        SearchResultEntry searchResultEntry = new SearchResultEntry();
        searchResultEntry.setObjectName(snickersSearchResultResponse.getObjectName());
        searchResultEntry.setPartialAttributeList(snickersSearchResultResponse.getAttributes());
        twixMessage.setProtocolOP((Asn1Object)searchResultEntry);
    }

    private void transformSearchResultReference(LdapMessage twixMessage, Message snickersMessage) {
        Collection<String> urls;
        SearchResponseReferenceImpl snickersSearchResponseReference = (SearchResponseReferenceImpl)snickersMessage;
        SearchResultReference searchResultReference = new SearchResultReference();
        Referral referrals = snickersSearchResponseReference.getReferral();
        if (referrals != null && (urls = referrals.getLdapUrls()) != null) {
            for (String urlValue : urls) {
                try {
                    searchResultReference.addSearchResultReference(new LdapURL(urlValue));
                }
                catch (LdapURLEncodingException luee) {
                    log.warn("The LdapURL " + urlValue + " is incorrect : " + luee.getMessage());
                }
            }
        }
        twixMessage.setProtocolOP((Asn1Object)searchResultReference);
    }

    public Object transform(Message msg) {
        if (IS_DEBUG) {
            log.debug("Transforming message type " + (Object)((Object)msg.getType()));
        }
        LdapMessage twixMessage = new LdapMessage();
        twixMessage.setMessageId(msg.getMessageId());
        switch (msg.getType()) {
            case SEARCH_RES_ENTRY: {
                this.transformSearchResultEntry(twixMessage, msg);
                break;
            }
            case SEARCH_RES_DONE: {
                this.transformSearchResultDone(twixMessage, msg);
                break;
            }
            case SEARCH_RES_REF: {
                this.transformSearchResultReference(twixMessage, msg);
                break;
            }
            case BIND_RESPONSE: {
                this.transformBindResponse(twixMessage, msg);
                break;
            }
            case ADD_RESPONSE: {
                this.transformAddResponse(twixMessage, msg);
                break;
            }
            case COMPARE_RESPONSE: {
                this.transformCompareResponse(twixMessage, msg);
                break;
            }
            case DEL_RESPONSE: {
                this.transformDelResponse(twixMessage, msg);
                break;
            }
            case MODIFY_RESPONSE: {
                this.transformModifyResponse(twixMessage, msg);
                break;
            }
            case MOD_DN_RESPONSE: {
                this.transformModifyDNResponse(twixMessage, msg);
                break;
            }
            case EXTENDED_RESP: {
                this.transformExtendedResponse(twixMessage, msg);
            }
        }
        if (!msg.getControls().isEmpty()) {
            this.transformControls(twixMessage, msg);
        }
        if (IS_DEBUG) {
            log.debug("Transformed message : " + (Object)((Object)twixMessage));
        }
        return twixMessage;
    }

    private void transformControls(LdapMessage twixMessage, Message msg) {
        for (javax.naming.ldap.Control control : msg.getControls().values()) {
            Control twixControl = new Control();
            twixMessage.addControl(twixControl);
            twixControl.setCriticality(control.isCritical());
            twixControl.setControlValue(control.getEncodedValue());
            twixControl.setEncodedValue(control.getEncodedValue());
            twixControl.setControlType(control.getID());
            twixControl.setParent(twixMessage);
        }
    }
}

