/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class RegexNormalizer
implements Normalizer {
    public static final long serialVersionUID = 1L;
    private final Pattern[] regexes;
    private final Matcher[] matchers;

    public RegexNormalizer(Pattern[] regexes) {
        if (regexes != null) {
            this.regexes = new Pattern[regexes.length];
            System.arraycopy(regexes, 0, this.regexes, 0, regexes.length);
        } else {
            this.regexes = null;
        }
        this.matchers = new Matcher[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            this.matchers[i] = regexes[i].matcher("");
        }
    }

    public Object normalize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String str = (String)value;
            for (int i = 0; i < this.matchers.length; ++i) {
                str = this.matchers[i].replaceAll(str);
            }
            return str;
        }
        return value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RegexNormalizer( ");
        for (int i = 0; i < this.regexes.length; ++i) {
            buf.append(this.regexes[i]);
            if (i >= this.regexes.length - 1) continue;
            buf.append(", ");
        }
        buf.append(" )");
        return buf.toString();
    }
}

