/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitLessOrEqualFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitLessOrEqualFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitLessOrEqualFilterAction() {
        super("Initialize Less Or Equal filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(ldapMessageContainer.getTlvId(), 2);
        searchRequest.addCurrentFilter(filter);
        searchRequest.setTerminalFilter(filter);
        if (IS_DEBUG) {
            log.debug("Initialize Less Or Equal filter");
        }
    }
}

