/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.trigger;

import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.apache.directory.shared.ldap.trigger.ActionTime;
import org.apache.directory.shared.ldap.trigger.LdapOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerSpecification {
    private LdapOperation ldapOperation;
    private ActionTime actionTime;
    private List<SPSpec> spSpecs;

    public TriggerSpecification(LdapOperation ldapOperation, ActionTime actionTime, List<SPSpec> spSpecs) {
        if (ldapOperation == null || actionTime == null || spSpecs == null) {
            throw new NullArgumentException("TriggerSpecification cannot be initialized with any NULL argument.");
        }
        if (spSpecs.size() == 0) {
            throw new IllegalArgumentException("TriggerSpecification cannot be initialized with emtpy SPSPec list.");
        }
        this.ldapOperation = ldapOperation;
        this.actionTime = actionTime;
        this.spSpecs = spSpecs;
    }

    public ActionTime getActionTime() {
        return this.actionTime;
    }

    public LdapOperation getLdapOperation() {
        return this.ldapOperation;
    }

    public List<SPSpec> getSPSpecs() {
        return this.spSpecs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SPSpec {
        private String name;
        private List<String> options;
        private List<String> parameters;

        public SPSpec(String name, List<String> options, List<String> parameters) {
            this.name = name;
            this.options = options;
            this.parameters = parameters;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.options == null ? 0 : ((Object)this.options).hashCode());
            result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SPSpec other = (SPSpec)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.options == null ? other.options != null : !((Object)this.options).equals(other.options)) {
                return false;
            }
            return !(this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters));
        }
    }
}

