/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.sp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.SerializationUtils;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.extended.StoredProcedureRequest;
import org.apache.directory.shared.ldap.message.extended.StoredProcedureResponse;
import org.apache.directory.shared.ldap.sp.LdapContextParameter;

public class JavaStoredProcedureUtils {
    public static byte[] getClassFileAsStream(Class clazz) throws NamingException {
        String fullClassName = clazz.getName();
        int lastDot = fullClassName.lastIndexOf(46);
        String classFileName = fullClassName.substring(lastDot + 1) + ".class";
        URL url = clazz.getResource(classFileName);
        InputStream in = clazz.getResourceAsStream(classFileName);
        File file = new File(url.getFile());
        int size = (int)file.length();
        byte[] buf = new byte[size];
        try {
            in.read(buf);
            in.close();
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return buf;
    }

    public static void loadStoredProcedureClass(LdapContext ctx, Class clazz) throws NamingException {
        byte[] buf = JavaStoredProcedureUtils.getClassFileAsStream(clazz);
        String fullClassName = clazz.getName();
        AttributesImpl attributes = new AttributesImpl("objectClass", "top", true);
        attributes.get("objectClass").add("javaClass");
        attributes.put("fullyQualifiedJavaClassName", fullClassName);
        attributes.put("javaClassByteCode", buf);
        ctx.createSubcontext("fullyQualifiedJavaClassName=" + fullClassName, (Attributes)attributes);
    }

    public static Object callStoredProcedure(LdapContext ctx, String procedureName, Object[] arguments) throws NamingException {
        Object responseObject;
        String language = "Java";
        try {
            StoredProcedureRequest req = new StoredProcedureRequest(0, procedureName, language);
            for (int i = 0; i < arguments.length; ++i) {
                byte[] value;
                byte[] type;
                if (arguments[i] instanceof LdapContextParameter) {
                    LdapContextParameter lcp = (LdapContextParameter)arguments[i];
                    type = lcp.getType().getBytes("UTF-8");
                    value = SerializationUtils.serialize((Serializable)((Serializable)lcp.getValue()));
                } else {
                    type = arguments[i].getClass().getName().getBytes("UTF-8");
                    value = SerializationUtils.serialize((Serializable)((Serializable)arguments[i]));
                }
                req.addParameter(type, value);
            }
            StoredProcedureResponse resp = (StoredProcedureResponse)ctx.extendedOperation(req);
            byte[] responseStream = resp.getEncodedValue();
            responseObject = SerializationUtils.deserialize((byte[])responseStream);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return responseObject;
    }
}

