/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import java.util.regex.Pattern;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class GeneralizedTimeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.24";
    private static final String GENERALIZED_TIME_PATTERN = "^\\d{4}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])([01]\\d|2[0-3])(([0-5]\\d)([0-5]\\d|60)?)?([.,]\\d+)?(Z|[+-]([01]\\d|2[0-3])([0-5]\\d)?)$";
    private Pattern datePattern = Pattern.compile("^\\d{4}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])([01]\\d|2[0-3])(([0-5]\\d)([0-5]\\d|60)?)?([.,]\\d+)?(Z|[+-]([01]\\d|2[0-3])([0-5]\\d)?)$");

    public GeneralizedTimeSyntaxChecker() {
        super(SC_OID);
    }

    protected GeneralizedTimeSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 11) {
            return false;
        }
        return this.datePattern.matcher(strValue).find();
    }
}

