/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DerefAliasesEnum {
    NEVER_DEREF_ALIASES(0),
    DEREF_IN_SEARCHING(1),
    DEREF_FINDING_BASE_OBJ(2),
    DEREF_ALWAYS(3);

    private int value;
    public static final String JNDI_DEREF_ALIAS_PROP = "java.naming.ldap.derefAliases";

    private DerefAliasesEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DerefAliasesEnum getEnum(Map<String, DerefAliasesEnum> env) {
        DerefAliasesEnum property = env.get(JNDI_DEREF_ALIAS_PROP);
        if (null == property) {
            return DEREF_ALWAYS;
        }
        return property;
    }

    public boolean isDerefAlways() {
        return this == DEREF_ALWAYS;
    }

    public boolean isNeverDeref() {
        return this == NEVER_DEREF_ALIASES;
    }

    public boolean isDerefInSearching() {
        switch (this) {
            case DEREF_ALWAYS: {
                return true;
            }
            case DEREF_FINDING_BASE_OBJ: {
                return false;
            }
            case DEREF_IN_SEARCHING: {
                return true;
            }
            case NEVER_DEREF_ALIASES: {
                return false;
            }
        }
        throw new IllegalArgumentException("Class has bug: check for valid enumeration values");
    }

    public boolean isDerefFindingBase() {
        switch (this) {
            case DEREF_ALWAYS: {
                return true;
            }
            case DEREF_FINDING_BASE_OBJ: {
                return true;
            }
            case DEREF_IN_SEARCHING: {
                return false;
            }
            case NEVER_DEREF_ALIASES: {
                return false;
            }
        }
        throw new IllegalArgumentException("Class has bug: check for valid enumeration values");
    }
}

