/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.Permission;
import org.apache.directory.shared.ldap.aci.ProtectedItem;

public class UserPermission
extends Permission {
    private static final long serialVersionUID = 3940100745409337694L;
    private final Collection protectedItems;

    public UserPermission(int precedence, Collection grantsAndDenials, Collection protectedItems) {
        super(precedence, grantsAndDenials);
        for (Object val : protectedItems) {
            if (val instanceof ProtectedItem) continue;
            throw new IllegalArgumentException("protectedItems contains a wrong element.");
        }
        this.protectedItems = Collections.unmodifiableCollection(protectedItems);
    }

    public Collection getProtectedItems() {
        return this.protectedItems;
    }

    public String toString() {
        return "itemPermission: precedence=" + this.getPrecedence() + ", " + "protectedItems=" + this.protectedItems + ", " + "grantsAndDenials=" + this.getGrantsAndDenials();
    }

    public void printToBuffer(StringBuffer buffer) {
        buffer.append('{');
        buffer.append(' ');
        if (this.getPrecedence() >= 0 && this.getPrecedence() <= 255) {
            buffer.append("precedence");
            buffer.append(' ');
            buffer.append(this.getPrecedence());
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append("protectedItems");
        buffer.append(' ');
        buffer.append('{');
        buffer.append(' ');
        Iterator it = this.protectedItems.iterator();
        while (it.hasNext()) {
            ProtectedItem item = (ProtectedItem)it.next();
            item.printToBuffer(buffer);
            if (!it.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(' ');
        buffer.append('}');
        buffer.append(',');
        buffer.append(' ');
        buffer.append("grantsAndDenials");
        buffer.append(' ');
        buffer.append('{');
        buffer.append(' ');
        it = this.getGrantsAndDenials().iterator();
        while (it.hasNext()) {
            GrantAndDenial grantAndDenial = (GrantAndDenial)it.next();
            grantAndDenial.printToBuffer(buffer);
            if (!it.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(' ');
        buffer.append('}');
        buffer.append(' ');
        buffer.append('}');
    }
}

