/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class AttributeUtils {
    public static boolean containsValue(Attribute attr, Object compared, AttributeType type) throws NamingException {
        Normalizer normalizer = type.getEquality().getNormalizer();
        if (type.getSyntax().isHumanReadible()) {
            String comparedStr = (String)normalizer.normalize(compared);
            for (int ii = attr.size(); ii >= 0; --ii) {
                String value = (String)attr.get(ii);
                if (!comparedStr.equals(normalizer.normalize(value))) continue;
                return true;
            }
        } else {
            byte[] comparedBytes = (byte[])compared;
            for (int ii = attr.size(); ii >= 0; --ii) {
                if (!ArrayUtils.isEquals(comparedBytes, attr.get(ii))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAnyValues(Attribute attr, Object[] compared, AttributeType type) throws NamingException {
        Normalizer normalizer = type.getEquality().getNormalizer();
        if (type.getSyntax().isHumanReadible()) {
            for (int jj = 0; jj < compared.length; ++jj) {
                String comparedStr = (String)normalizer.normalize(compared[jj]);
                for (int ii = attr.size(); ii >= 0; --ii) {
                    String value = (String)attr.get(ii);
                    if (!comparedStr.equals(normalizer.normalize(value))) continue;
                    return true;
                }
            }
        } else {
            for (int jj = 0; jj < compared.length; ++jj) {
                byte[] comparedBytes = (byte[])compared[jj];
                for (int ii = attr.size(); ii >= 0; --ii) {
                    if (!ArrayUtils.isEquals(comparedBytes, attr.get(ii))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Attribute getDifference(Attribute attr0, Attribute attr1) throws NamingException {
        int ii;
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException("Cannot figure out attribute ID if both args are null");
        }
        if (attr0 == null) {
            return new LockableAttributeImpl(attr1.getID());
        }
        if (attr1 == null) {
            return (Attribute)attr0.clone();
        }
        if (!attr0.getID().equalsIgnoreCase(attr1.getID())) {
            throw new IllegalArgumentException("Cannot take difference of attributes with different IDs!");
        }
        String id = attr0.getID();
        LockableAttributeImpl attr = new LockableAttributeImpl(id);
        if (attr0 != null) {
            for (ii = 0; ii < attr0.size(); ++ii) {
                attr.add(attr0.get(ii));
            }
        }
        if (attr1 != null) {
            for (ii = 0; ii < attr1.size(); ++ii) {
                attr.remove(attr1.get(ii));
            }
        }
        return attr;
    }

    public static Attribute getUnion(Attribute attr0, Attribute attr1) throws NamingException {
        int ii;
        String id;
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException("Cannot figure out attribute ID if both args are null");
        }
        if (attr0 == null) {
            id = attr1.getID();
        } else if (attr1 == null) {
            id = attr0.getID();
        } else {
            if (!attr0.getID().equalsIgnoreCase(attr1.getID())) {
                throw new IllegalArgumentException("Cannot take union of attributes with different IDs!");
            }
            id = attr0.getID();
        }
        LockableAttributeImpl attr = new LockableAttributeImpl(id);
        if (attr0 != null) {
            for (ii = 0; ii < attr0.size(); ++ii) {
                attr.add(attr0.get(ii));
            }
        }
        if (attr1 != null) {
            for (ii = 0; ii < attr1.size(); ++ii) {
                attr.add(attr1.get(ii));
            }
        }
        return attr;
    }

    public static String toString(String tabs, Attributes attributes) {
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append("Attributes\n");
        NamingEnumeration<? extends Attribute> attributesIterator = attributes.getAll();
        while (attributesIterator.hasMoreElements()) {
            Attribute attribute = (Attribute)attributesIterator.nextElement();
            sb.append(tabs).append("    Type : '").append(attribute.getID()).append("'\n");
            for (int j = 0; j < attribute.size(); ++j) {
                try {
                    Object attr = attribute.get(j);
                    if (attr instanceof String) {
                        sb.append(tabs).append("        Val[").append(j).append("] : ").append(attr).append(" \n");
                        continue;
                    }
                    if (attr instanceof byte[]) {
                        String string = StringTools.utf8ToString((byte[])attr);
                        sb.append(tabs).append("        Val[").append(j).append("] : ");
                        sb.append(string).append('/');
                        sb.append(StringTools.dumpBytes((byte[])attr));
                        sb.append(" \n");
                        continue;
                    }
                    sb.append(tabs).append("        Val[").append(j).append("] : ").append(attr).append(" \n");
                    continue;
                }
                catch (NamingException ne) {
                    sb.append("Bad attribute : ").append(ne.getMessage());
                }
            }
        }
        return sb.toString();
    }

    public static String toString(Attributes attributes) {
        return AttributeUtils.toString("", attributes);
    }
}

