/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnect;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnectContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnectStatesEnum;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulDisconnectGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)GracefulDisconnectGrammar.class);
    private static IGrammar instance = new GracefulDisconnectGrammar();

    private GracefulDisconnectGrammar() {
        this.name = GracefulDisconnectGrammar.class.getName();
        this.statesEnum = GracefulDisconnectStatesEnum.getInstance();
        this.transitions = new GrammarTransition[GracefulDisconnectStatesEnum.LAST_GRACEFUL_DISCONNECT_STATE][256];
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_TAG][48] = new GrammarTransition(GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_TAG, GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_VALUE, null);
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_VALUE][48] = new GrammarTransition(GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_VALUE, GracefulDisconnectStatesEnum.TIME_OFFLINE_OR_DELAY_OR_REPLICATED_OR_END_TAG, new GrammarAction("Init Graceful Disconnect"){

            public void action(IAsn1Container container) {
                GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
                GracefulDisconnect gracefulDisconnect = new GracefulDisconnect();
                gracefulDisconnectContainer.setGracefulDisconnect(gracefulDisconnect);
                gracefulDisconnectContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_OR_DELAY_OR_REPLICATED_OR_END_TAG][2] = new GrammarTransition(GracefulDisconnectStatesEnum.TIME_OFFLINE_OR_DELAY_OR_REPLICATED_OR_END_TAG, GracefulDisconnectStatesEnum.TIME_OFFLINE_VALUE, null);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_OR_DELAY_OR_REPLICATED_OR_END_TAG][128] = new GrammarTransition(GracefulDisconnectStatesEnum.TIME_OFFLINE_OR_DELAY_OR_REPLICATED_OR_END_TAG, GracefulDisconnectStatesEnum.DELAY_VALUE, null);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_OR_DELAY_OR_REPLICATED_OR_END_TAG][48] = new GrammarTransition(GracefulDisconnectStatesEnum.TIME_OFFLINE_OR_DELAY_OR_REPLICATED_OR_END_TAG, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_VALUE, null);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_VALUE][2] = new GrammarTransition(GracefulDisconnectStatesEnum.TIME_OFFLINE_VALUE, GracefulDisconnectStatesEnum.DELAY_OR_REPLICATED_OR_END_TAG, new GrammarAction("Set Graceful Disconnect time offline"){

            public void action(IAsn1Container container) throws DecoderException {
                GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
                Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
                try {
                    int timeOffline = IntegerDecoder.parse((Value)value, (int)0, (int)720);
                    if (log.isDebugEnabled()) {
                        log.debug("Time Offline = " + timeOffline);
                    }
                    gracefulDisconnectContainer.getGracefulDisconnect().setTimeOffline(timeOffline);
                    gracefulDisconnectContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the timeOffline, the value should be between 0 and 720 minutes, it is '" + StringTools.dumpBytes(value.getData()) + "'";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulDisconnectStatesEnum.DELAY_OR_REPLICATED_OR_END_TAG][128] = new GrammarTransition(GracefulDisconnectStatesEnum.DELAY_OR_REPLICATED_OR_END_TAG, GracefulDisconnectStatesEnum.DELAY_VALUE, null);
        this.transitions[GracefulDisconnectStatesEnum.DELAY_VALUE][128] = new GrammarTransition(GracefulDisconnectStatesEnum.DELAY_VALUE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_OR_END_TAG, new GrammarAction("Set Graceful Disconnect Delay"){

            public void action(IAsn1Container container) throws DecoderException {
                GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
                Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse((Value)value, (int)0, (int)86400);
                    if (log.isDebugEnabled()) {
                        log.debug("Delay = " + delay);
                    }
                    gracefulDisconnectContainer.getGracefulDisconnect().setDelay(delay);
                    gracefulDisconnectContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the delay, the value should be between 0 and 86400 seconds, it is '" + StringTools.dumpBytes(value.getData()) + "'";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_OR_END_TAG][48] = new GrammarTransition(GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_OR_END_TAG, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_VALUE, null);
        this.transitions[GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_VALUE][48] = new GrammarTransition(GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_VALUE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXT_OR_END_TAG, null);
        this.transitions[GracefulDisconnectStatesEnum.REPLICATED_CONTEXT_OR_END_TAG][4] = new GrammarTransition(GracefulDisconnectStatesEnum.REPLICATED_CONTEXT_OR_END_TAG, GracefulDisconnectStatesEnum.REPLICATED_CONTEXT_VALUE, null);
        this.transitions[GracefulDisconnectStatesEnum.REPLICATED_CONTEXT_VALUE][4] = new GrammarTransition(GracefulDisconnectStatesEnum.REPLICATED_CONTEXT_VALUE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXT_OR_END_TAG, new GrammarAction("Replicated context URL"){

            public void action(IAsn1Container container) throws DecoderException {
                GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
                Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
                try {
                    LdapURL url = new LdapURL(value.getData());
                    gracefulDisconnectContainer.getGracefulDisconnect().addReplicatedContexts(url);
                    gracefulDisconnectContainer.grammarEndAllowed(true);
                }
                catch (LdapURLEncodingException e) {
                    String msg = "failed to decode the URL '" + StringTools.dumpBytes(value.getData()) + "'";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

