/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class RegexNormalizer
implements Normalizer {
    private final Pattern[] regexes;
    private final Matcher[] matchers;

    public RegexNormalizer(Pattern[] regexes) {
        this.regexes = regexes;
        this.matchers = new Matcher[regexes.length];
        int i = 0;
        while (i < regexes.length) {
            this.matchers[i] = regexes[i].matcher("");
            ++i;
        }
    }

    public Object normalize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String str = (String)value;
            int i = 0;
            while (i < this.matchers.length) {
                str = this.matchers[i].replaceAll(str);
                ++i;
            }
            return str;
        }
        return value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RegexNormalizer( ");
        int i = 0;
        while (i < this.regexes.length) {
            buf.append(this.regexes[i]);
            if (i < this.regexes.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(" )");
        return buf.toString();
    }
}

